/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.parser;

import de.skuzzle.enforcer.restrictimports.util.Preconditions;
import de.skuzzle.enforcer.restrictimports.util.StringRepresentation;
import java.util.Objects;

public final class ImportStatement {
    private static final String IMPORT_PREFIX = "import ";
    private static final String STATIC_PREFIX = "static ";
    private final String importName;
    private final int line;
    private final boolean staticImport;

    public ImportStatement(String importName, int line, boolean staticImport) {
        Preconditions.checkArgument(importName != null && !importName.isEmpty(), "importName must not be empty", new Object[0]);
        Preconditions.checkArgument(!importName.startsWith(IMPORT_PREFIX), "importName should be the raw package name without 'import ' prefix but was: '%s'", importName);
        Preconditions.checkArgument(!importName.startsWith(STATIC_PREFIX), "importName should be the raw package name without 'static ' prefix but was: '%s'", importName);
        Preconditions.checkArgument(importName.trim().equals(importName), "importName has leading or trailing spaces: '%s'", importName);
        Preconditions.checkArgument(line > 0, "line numbers should be 1-based and not start at 0", new Object[0]);
        this.importName = importName;
        this.line = line;
        this.staticImport = staticImport;
    }

    public int getLine() {
        return this.line;
    }

    public String getImportName() {
        if (this.staticImport) {
            return STATIC_PREFIX + this.importName;
        }
        return this.importName;
    }

    public String getFqcn() {
        return this.importName;
    }

    public String toString() {
        return StringRepresentation.ofInstance(this).add("import", this.importName).add("line", this.line).add("static", this.staticImport).toString();
    }

    public int hashCode() {
        return Objects.hash(this.importName, this.line, this.staticImport);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ImportStatement && Objects.equals(this.line, ((ImportStatement)obj).line) && Objects.equals(this.staticImport, ((ImportStatement)obj).staticImport) && Objects.equals(this.importName, ((ImportStatement)obj).importName);
    }
}

