/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.formatting;

import java.time.Duration;

final class DurationFormat {
    private DurationFormat() {
    }

    public static String formatDuration(Duration duration) {
        long seconds;
        if (duration.getSeconds() == 0L) {
            return "less than 1 second";
        }
        StringBuilder result = new StringBuilder();
        long minutes = duration.toMinutes();
        if (minutes > 0L) {
            result.append(DurationFormat.pluralize(minutes, " minute"));
        }
        if ((seconds = duration.getSeconds() % 60L) > 0L) {
            if (result.length() != 0) {
                result.append(" and ");
            }
            result.append(DurationFormat.pluralize(seconds, " second"));
        }
        return result.toString();
    }

    private static String pluralize(long value, String singular) {
        return value == 1L ? value + singular : value + singular + "s";
    }
}

