/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import de.skuzzle.enforcer.restrictimports.analyze.AnalyzeResult;
import de.skuzzle.enforcer.restrictimports.analyze.AnalyzerSettings;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroups;
import de.skuzzle.enforcer.restrictimports.analyze.ImportAnalyzer;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedFile;
import de.skuzzle.enforcer.restrictimports.analyze.SourceTreeAnalyzer;
import de.skuzzle.enforcer.restrictimports.parser.ImportStatementParser;
import de.skuzzle.enforcer.restrictimports.parser.ParsedFile;
import de.skuzzle.enforcer.restrictimports.parser.lang.LanguageSupport;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SourceTreeAnalyzerImpl
implements SourceTreeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceTreeAnalyzerImpl.class);
    private final ImportAnalyzer importAnalyzer = new ImportAnalyzer();
    private final Predicate<Path> supportedFileTypes = LanguageSupport::isLanguageSupported;

    SourceTreeAnalyzerImpl() {
    }

    @Override
    public AnalyzeResult analyze(AnalyzerSettings settings, BannedImportGroups groups) {
        long start = System.currentTimeMillis();
        ImportStatementParser fileParser = ImportStatementParser.forCharset(settings.getSourceFileCharset());
        if (settings.isParallel()) {
            LOGGER.warn("EXPERIMENTAL FEATURE enabled. You have enabled parallel analysis which is marked as experimental. Please be aware that experimental features might get removed. Please share your feedback!");
        }
        ThreadSafeCounter counter = new ThreadSafeCounter();
        Collection<MatchedFile> srcMatches = this.analyzeDirectories(groups, fileParser, settings.getSrcDirectories(), settings.isParallel(), counter);
        Collection<MatchedFile> testMatches = this.analyzeDirectories(groups, fileParser, settings.getTestDirectories(), settings.isParallel(), counter);
        long stop = System.currentTimeMillis();
        long duration = stop - start;
        return AnalyzeResult.builder().withMatches(srcMatches).withMatchesInTestCode(testMatches).withDuration(duration).withAnalysedFileCount(counter.count()).build();
    }

    private Collection<MatchedFile> analyzeDirectories(BannedImportGroups groups, ImportStatementParser fileParser, Iterable<Path> directories, boolean parallel, ThreadSafeCounter counter) {
        return StreamSupport.stream(directories.spliterator(), parallel).flatMap(srcDir -> this.analyzeDirectory(groups, fileParser, (Path)srcDir, parallel, counter)).collect(Collectors.toList());
    }

    private Stream<MatchedFile> analyzeDirectory(BannedImportGroups groups, ImportStatementParser fileParser, Path srcDir, boolean parallel, ThreadSafeCounter counter) {
        try (Stream<Path> sourceFiles = this.parallelize(this.listFiles(srcDir, this.supportedFileTypes), parallel);){
            List matches = sourceFiles.peek(counter).map(fileParser::parse).map(this.analyzeAgainst(groups)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            Stream<MatchedFile> stream = this.parallelize(matches.stream(), parallel);
            return stream;
        }
    }

    private <T> Stream<T> parallelize(Stream<T> stream, boolean parallel) {
        return parallel ? (Stream)stream.parallel() : stream;
    }

    private Function<ParsedFile, Optional<MatchedFile>> analyzeAgainst(BannedImportGroups groups) {
        return parsedFile -> this.importAnalyzer.matchFile((ParsedFile)parsedFile, groups);
    }

    private Stream<Path> listFiles(Path root, Predicate<Path> filter) {
        try {
            if (!Files.exists(root, new LinkOption[0])) {
                return Stream.empty();
            }
            return Files.find(root, Integer.MAX_VALUE, (path, bfa) -> filter.test((Path)path), new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Encountered IOException while listing files of " + root, e);
        }
    }

    private static class ThreadSafeCounter
    implements Consumer<Object> {
        private final AtomicInteger counter = new AtomicInteger();

        private ThreadSafeCounter() {
        }

        @Override
        public void accept(Object t) {
            this.counter.incrementAndGet();
        }

        public int count() {
            return this.counter.get();
        }
    }
}

