/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import de.skuzzle.enforcer.restrictimports.analyze.PackagePattern;
import de.skuzzle.enforcer.restrictimports.util.Preconditions;
import de.skuzzle.enforcer.restrictimports.util.StringRepresentation;
import java.util.Objects;

public final class MatchedImport {
    private final int importLine;
    private final String matchedString;
    private final PackagePattern matchedBy;

    MatchedImport(int importLine, String matchedString, PackagePattern matchedBy) {
        Preconditions.checkArgument(matchedString != null && !matchedString.isEmpty(), "matched String must not be empty", new Object[0]);
        Preconditions.checkArgument(matchedBy != null, "matchedBy should not be null", new Object[0]);
        Preconditions.checkArgument(importLine > 0, "line numbers should be 1-based and not start at 0", new Object[0]);
        this.importLine = importLine;
        this.matchedString = matchedString;
        this.matchedBy = matchedBy;
    }

    public int getImportLine() {
        return this.importLine;
    }

    public String getMatchedString() {
        return this.matchedString;
    }

    public PackagePattern getMatchedBy() {
        return this.matchedBy;
    }

    public int hashCode() {
        return Objects.hash(this.importLine, this.matchedString, this.matchedBy);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof MatchedImport && Objects.equals(this.importLine, ((MatchedImport)obj).importLine) && Objects.equals(this.matchedString, ((MatchedImport)obj).matchedString) && Objects.equals(this.matchedBy, ((MatchedImport)obj).matchedBy);
    }

    public String toString() {
        return StringRepresentation.ofInstance(this).add("importLine", this.importLine).add("matchedString", this.matchedString).add("matchedBy", this.matchedBy).toString();
    }
}

