/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedImport;
import de.skuzzle.enforcer.restrictimports.analyze.PackagePattern;
import de.skuzzle.enforcer.restrictimports.util.Preconditions;
import de.skuzzle.enforcer.restrictimports.util.StringRepresentation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class MatchedFile {
    private final Path sourceFile;
    private final List<MatchedImport> matchedImports;
    private final BannedImportGroup matchedBy;

    MatchedFile(Path sourceFile, List<MatchedImport> matchedImports, BannedImportGroup matchedBy) {
        this.sourceFile = sourceFile;
        this.matchedImports = matchedImports;
        this.matchedBy = matchedBy;
    }

    public static Builder forSourceFile(Path sourceFile) {
        return new Builder(sourceFile);
    }

    public Path getSourceFile() {
        return this.sourceFile;
    }

    public List<MatchedImport> getMatchedImports() {
        return this.matchedImports;
    }

    public BannedImportGroup getMatchedBy() {
        return this.matchedBy;
    }

    public int hashCode() {
        return Objects.hash(this.sourceFile, this.matchedImports, this.matchedBy);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof MatchedFile && Objects.equals(this.sourceFile, ((MatchedFile)obj).sourceFile) && Objects.equals(this.matchedImports, ((MatchedFile)obj).matchedImports) && Objects.equals(this.matchedBy, ((MatchedFile)obj).matchedBy);
    }

    public String toString() {
        return StringRepresentation.ofInstance(this).add("sourceFile", this.sourceFile).add("matchedImports", this.matchedImports).add("matchedBy", this.matchedBy).toString();
    }

    public static class Builder {
        private final Path sourceFile;
        private final List<MatchedImport> matchedImports = new ArrayList<MatchedImport>();
        private BannedImportGroup matchedBy;

        private Builder(Path sourceFile) {
            Preconditions.checkArgument(sourceFile != null, "sourceFile must not be null", new Object[0]);
            this.sourceFile = sourceFile;
        }

        public Builder withMatchAt(int importLine, String matchedString, PackagePattern matchedBy) {
            this.matchedImports.add(new MatchedImport(importLine, matchedString, matchedBy));
            return this;
        }

        public Builder matchedBy(BannedImportGroup group) {
            this.matchedBy = group;
            return this;
        }

        public MatchedFile build() {
            Preconditions.checkArgument(this.matchedBy != null, "matchedBy must not be null for MatchedFile %s", this.sourceFile);
            return new MatchedFile(this.sourceFile, this.matchedImports, this.matchedBy);
        }
    }
}

