/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.rule;

import com.google.common.base.Preconditions;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.analyze.PackagePattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BannedImportGroupDefinition {
    private static final PackagePattern DEFAULT_BASE_PACKAGE = PackagePattern.parse("**");
    private PackagePattern basePackage = DEFAULT_BASE_PACKAGE;
    private List<PackagePattern> basePackages = new ArrayList<PackagePattern>();
    private PackagePattern bannedImport = null;
    private List<PackagePattern> bannedImports = new ArrayList<PackagePattern>();
    private PackagePattern allowedImport = null;
    private List<PackagePattern> allowedImports = new ArrayList<PackagePattern>();
    private PackagePattern exclusion = null;
    private List<PackagePattern> exclusions = new ArrayList<PackagePattern>();
    private String reason;

    public BannedImportGroup createGroupFromPluginConfiguration() {
        return BannedImportGroup.builder().withBasePackages(this.assembleList(this.basePackage, this.basePackages)).withBannedImports(this.assembleList(this.bannedImport, this.bannedImports)).withAllowedImports(this.assembleList(this.allowedImport, this.allowedImports)).withExcludedClasses(this.assembleList(this.exclusion, this.exclusions)).withReason(this.reason).build();
    }

    public boolean hasInput() {
        return this.basePackage != DEFAULT_BASE_PACKAGE || !this.basePackages.isEmpty() || this.bannedImport != null || !this.bannedImports.isEmpty() || this.allowedImport != null || !this.allowedImports.isEmpty() || this.exclusion != null || !this.exclusions.isEmpty();
    }

    private List<PackagePattern> assembleList(PackagePattern single, List<PackagePattern> multi) {
        if (single == null) {
            return multi;
        }
        return Collections.singletonList(single);
    }

    public void setBasePackage(String basePackage) {
        Preconditions.checkArgument((boolean)this.basePackages.isEmpty(), (Object)"Configuration error: you should either specify a single base package using <basePackage> or multiple base packages using <basePackages> but not both");
        this.basePackage = PackagePattern.parse(basePackage);
    }

    public void setBasePackages(List<String> basePackages) {
        Preconditions.checkArgument((this.basePackage == DEFAULT_BASE_PACKAGE ? 1 : 0) != 0, (Object)"Configuration error: you should either specify a single base package using <basePackage> or multiple base packages using <basePackages> but not both");
        Preconditions.checkArgument((basePackages != null && !basePackages.isEmpty() ? 1 : 0) != 0, (Object)"bannedPackages must not be empty");
        this.basePackage = null;
        this.basePackages = PackagePattern.parseAll(basePackages);
    }

    public void setBannedImport(String bannedImport) {
        Preconditions.checkArgument((boolean)this.bannedImports.isEmpty(), (Object)"Configuration error: you should either specify a single banned import using <bannedImport> or multiple banned imports using <bannedImports> but not both");
        Preconditions.checkArgument((this.bannedImport == null ? 1 : 0) != 0, (Object)"If you want to specify multiple banned imports you have to wrap them in a <bannedImports> tag");
        this.bannedImport = PackagePattern.parse(bannedImport);
    }

    public void setBannedImports(List<String> bannedPackages) {
        Preconditions.checkArgument((this.bannedImport == null ? 1 : 0) != 0, (Object)"Configuration error: you should either specify a single banned import using <bannedImport> or multiple banned imports using <bannedImports> but not both");
        Preconditions.checkArgument((bannedPackages != null && !bannedPackages.isEmpty() ? 1 : 0) != 0, (Object)"bannedPackages must not be empty");
        this.bannedImport = null;
        this.bannedImports = PackagePattern.parseAll(bannedPackages);
    }

    public void setAllowedImport(String allowedImport) {
        Preconditions.checkArgument((boolean)this.allowedImports.isEmpty(), (Object)"Configuration error: you should either specify a single allowed import using <allowedImport> or multiple allowed imports using <allowedImports> but not both");
        Preconditions.checkArgument((this.allowedImport == null ? 1 : 0) != 0, (Object)"If you want to specify multiple allowed imports you have to wrap them in a <allowedImports> tag");
        this.allowedImport = PackagePattern.parse(allowedImport);
    }

    public void setAllowedImports(List<String> allowedImports) {
        Preconditions.checkArgument((this.allowedImport == null ? 1 : 0) != 0, (Object)"Configuration error: you should either specify a single allowed import using <allowedImport> or multiple allowed imports using <allowedImports> but not both");
        this.allowedImports = PackagePattern.parseAll(allowedImports);
    }

    public void setExclusion(String exclusion) {
        Preconditions.checkArgument((boolean)this.exclusions.isEmpty(), (Object)"Configuration error: you should either specify a single exclusion using <exclusion> or multiple exclusions using <exclusions> but not both");
        Preconditions.checkArgument((this.exclusion == null ? 1 : 0) != 0, (Object)"If you want to specify multiple exclusions you have to wrap them in a <exclusions> tag");
        this.exclusion = PackagePattern.parse(exclusion);
    }

    public void setExclusions(List<String> exclusions) {
        Preconditions.checkArgument((this.exclusion == null ? 1 : 0) != 0, (Object)"Configuration error: you should either specify a single exclusion using <exclusion> or multiple exclusions using <exclusions> but not both");
        this.exclusions = PackagePattern.parseAll(exclusions);
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
}

