/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.parser.lang;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.skuzzle.enforcer.restrictimports.parser.ImportStatement;
import de.skuzzle.enforcer.restrictimports.parser.lang.LanguageSupport;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class KotlinGroovyLanguageSupport
implements LanguageSupport {
    private static final String IMPORT_STATEMENT = "import ";
    private static final String PACKAGE_STATEMENT = "package ";

    @Override
    public Set<String> getSupportedFileExtensions() {
        return ImmutableSet.of((Object)"groovy", (Object)"kt");
    }

    @Override
    public Optional<String> parsePackage(String line) {
        if (!this.isPackage(line)) {
            return Optional.empty();
        }
        return Optional.of(KotlinGroovyLanguageSupport.extractPackageName(line));
    }

    @Override
    public List<ImportStatement> parseImport(String line, int lineNumber) {
        if (!this.isImport(line)) {
            return ImmutableList.of();
        }
        String[] parts = line.split(";");
        return Arrays.stream(parts).map(String::trim).filter(s -> !s.isEmpty()).map(s -> s.substring(IMPORT_STATEMENT.length())).map(String::trim).map(this::removeAlias).map(importName -> new ImportStatement((String)importName, lineNumber)).collect(Collectors.toList());
    }

    private boolean is(String compare, String line) {
        return line.startsWith(compare);
    }

    private boolean isPackage(String line) {
        return this.is(PACKAGE_STATEMENT, line);
    }

    private boolean isImport(String line) {
        return this.is(IMPORT_STATEMENT, line);
    }

    private static String extractPackageName(String line) {
        int spaceIdx = line.indexOf(" ");
        int semiIdx = line.indexOf(";");
        if (semiIdx >= 0) {
            return line.substring(spaceIdx, semiIdx).trim();
        }
        return line.substring(spaceIdx).trim();
    }

    private String removeAlias(String packageWithAlias) {
        int asIdx = packageWithAlias.indexOf(" as ");
        if (asIdx >= 0) {
            return packageWithAlias.substring(0, asIdx);
        }
        return packageWithAlias;
    }
}

