/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.parser;

import com.google.common.base.Preconditions;
import de.skuzzle.enforcer.restrictimports.parser.ImportStatement;
import de.skuzzle.enforcer.restrictimports.parser.ImportStatementParser;
import de.skuzzle.enforcer.restrictimports.parser.LineSupplier;
import de.skuzzle.enforcer.restrictimports.parser.ParsedFile;
import de.skuzzle.enforcer.restrictimports.parser.lang.LanguageSupport;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImportStatementParserImpl
implements ImportStatementParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportStatementParserImpl.class);
    private final LineSupplier supplier;

    ImportStatementParserImpl(LineSupplier supplier) {
        this.supplier = supplier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ParsedFile parse(Path sourceFilePath, LanguageSupport languageSupport) {
        LOGGER.trace("Analyzing {} for imports", (Object)sourceFilePath);
        ArrayList<ImportStatement> imports = new ArrayList<ImportStatement>();
        String fileName = this.getFileNameWithoutExtension(sourceFilePath);
        try (Stream<String> lines = this.supplier.lines(sourceFilePath);){
            int row = 1;
            String packageName = "";
            String fqcn = fileName;
            Iterator it = lines.map(String::trim).iterator();
            while (it.hasNext()) {
                String line = (String)it.next();
                if (!line.isEmpty()) {
                    Optional<String> packageDeclaration = languageSupport.parsePackage(line);
                    if (packageDeclaration.isPresent()) {
                        Preconditions.checkState((boolean)packageName.isEmpty(), (String)"found duplicate package statement in '%s'", (Object)sourceFilePath);
                        packageName = packageDeclaration.get();
                        fqcn = this.guessFQCN(packageName, fileName);
                        LOGGER.trace("Guessed full qualified class name from {} and {}: '{}'", new Object[]{packageName, fileName, fqcn});
                    } else {
                        List<ImportStatement> importStatements = languageSupport.parseImport(line, row);
                        if (importStatements.isEmpty()) break;
                        imports.addAll(importStatements);
                    }
                }
                ++row;
            }
            ParsedFile parsedFile = new ParsedFile(sourceFilePath, packageName, fqcn, imports);
            return parsedFile;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Encountered IOException while analyzing %s for banned imports", sourceFilePath), e);
        }
    }

    private String guessFQCN(String packageName, String sourceFileName) {
        return packageName.isEmpty() ? sourceFileName : packageName + "." + sourceFileName;
    }

    private String getFileNameWithoutExtension(Path file) {
        String s = file.getFileName().toString();
        int i = s.lastIndexOf(".");
        return s.substring(0, i);
    }
}

