/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import de.skuzzle.enforcer.restrictimports.analyze.AnalyzeResult;
import de.skuzzle.enforcer.restrictimports.analyze.AnalyzerSettings;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroups;
import de.skuzzle.enforcer.restrictimports.analyze.ImportAnalyzer;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedFile;
import de.skuzzle.enforcer.restrictimports.analyze.SourceTreeAnalyzer;
import de.skuzzle.enforcer.restrictimports.parser.ImportStatementParser;
import de.skuzzle.enforcer.restrictimports.parser.ParsedFile;
import de.skuzzle.enforcer.restrictimports.parser.lang.LanguageSupport;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

final class SourceTreeAnalyzerImpl
implements SourceTreeAnalyzer {
    private final ImportAnalyzer importAnalyzer = new ImportAnalyzer();
    private final Predicate<Path> supportedFileTypes = new SourceFileMatcher();

    SourceTreeAnalyzerImpl() {
    }

    @Override
    public AnalyzeResult analyze(AnalyzerSettings settings, BannedImportGroups groups) {
        long start = System.currentTimeMillis();
        ImportStatementParser fileParser = ImportStatementParser.defaultInstance(settings.getSourceFileCharset());
        Collection<MatchedFile> srcMatches = this.analyzeDirectories(groups, fileParser, settings.getSrcDirectories());
        Collection<MatchedFile> testMatches = this.analyzeDirectories(groups, fileParser, settings.getTestDirectories());
        long stop = System.currentTimeMillis();
        long duration = stop - start;
        return AnalyzeResult.builder().withMatches(srcMatches).withMatchesInTestCode(testMatches).withDuration(duration).build();
    }

    private Collection<MatchedFile> analyzeDirectories(BannedImportGroups groups, ImportStatementParser fileParser, Iterable<Path> directories) {
        ArrayList<MatchedFile> matchedFiles = new ArrayList<MatchedFile>();
        for (Path srcDir : directories) {
            Stream<Path> sourceFiles = this.listFiles(srcDir, this.supportedFileTypes);
            Throwable throwable = null;
            try {
                sourceFiles.map(this.parseFileUsing(fileParser)).map(this.analyzeAgainst(groups)).filter(Optional::isPresent).map(Optional::get).forEach(matchedFiles::add);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (sourceFiles == null) continue;
                if (throwable != null) {
                    try {
                        sourceFiles.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                sourceFiles.close();
            }
        }
        return matchedFiles;
    }

    private Function<Path, ParsedFile> parseFileUsing(ImportStatementParser parser) {
        return sourceFile -> parser.parse((Path)sourceFile, this.getLanguageSupport((Path)sourceFile));
    }

    private Function<ParsedFile, Optional<MatchedFile>> analyzeAgainst(BannedImportGroups groups) {
        return parsedFile -> this.importAnalyzer.matchFile((ParsedFile)parsedFile, groups);
    }

    private Stream<Path> listFiles(Path root, Predicate<Path> filter) {
        try {
            if (!Files.exists(root, new LinkOption[0])) {
                return Stream.empty();
            }
            return Files.find(root, Integer.MAX_VALUE, (path, bfa) -> filter.test((Path)path), new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Encountered IOException while listing files of " + root, e);
        }
    }

    private LanguageSupport getLanguageSupport(Path sourceFile) {
        String extension = this.getFileExtension(sourceFile);
        return LanguageSupport.getLanguageSupport(extension).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find a LanguageSupport implementation for normalized file extension: '%s' (%s)", extension, sourceFile)));
    }

    private boolean isFile(Path path) {
        return !Files.isDirectory(path, new LinkOption[0]);
    }

    private String getFileExtension(Path path) {
        String fileName = path.getFileName().toString();
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return fileName.substring(index);
    }

    private class SourceFileMatcher
    implements Predicate<Path> {
        private SourceFileMatcher() {
        }

        @Override
        public boolean test(Path path) {
            if (!SourceTreeAnalyzerImpl.this.isFile(path)) {
                return false;
            }
            String extension = SourceTreeAnalyzerImpl.this.getFileExtension(path);
            return LanguageSupport.isLanguageSupported(extension);
        }
    }
}

