/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import com.google.common.base.Preconditions;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.analyze.PackagePattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class BannedImportGroups {
    private final List<BannedImportGroup> groups;

    private BannedImportGroups(List<BannedImportGroup> groups) {
        this.groups = groups;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<BannedImportGroup> selectGroupFor(String fqcn) {
        return this.groups.stream().map(group -> this.matches((BannedImportGroup)group, fqcn)).filter(Optional::isPresent).map(Optional::get).sorted().map(GroupMatch::getGroup).findFirst().filter(group -> !group.exclusionMatches(fqcn));
    }

    private Optional<GroupMatch> matches(BannedImportGroup group, String fqcn) {
        return group.getBasePackages().stream().filter(pattern -> pattern.matches(fqcn)).findFirst().map(basePackage -> new GroupMatch((PackagePattern)basePackage, group));
    }

    public int hashCode() {
        return Objects.hash(this.groups);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof BannedImportGroups && Objects.equals(this.groups, ((BannedImportGroups)obj).groups);
    }

    public String toString() {
        return this.groups.stream().map(BannedImportGroup::toString).collect(Collectors.joining(System.lineSeparator()));
    }

    public static final class Builder {
        private final List<BannedImportGroup> groups = new ArrayList<BannedImportGroup>();

        public Builder withGroups(Collection<BannedImportGroup> groups) {
            this.groups.addAll(groups);
            return this;
        }

        public Builder withGroup(BannedImportGroup group) {
            this.groups.add(group);
            return this;
        }

        public Builder withGroup(BannedImportGroup.Builder groupBuilder) {
            this.groups.add(groupBuilder.build());
            return this;
        }

        public BannedImportGroups build() {
            Preconditions.checkArgument((!this.groups.isEmpty() ? 1 : 0) != 0, (Object)"No BannedImportGroups have been specified");
            return new BannedImportGroups(this.groups);
        }
    }

    private static class GroupMatch
    implements Comparable<GroupMatch> {
        private final PackagePattern basePackage;
        private final BannedImportGroup group;

        public GroupMatch(PackagePattern basePackage, BannedImportGroup group) {
            this.basePackage = basePackage;
            this.group = group;
        }

        public BannedImportGroup getGroup() {
            return this.group;
        }

        @Override
        public int compareTo(GroupMatch o) {
            return o.basePackage.compareTo(this.basePackage);
        }
    }
}

