/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import com.google.common.base.MoreObjects;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public final class AnalyzerSettings {
    private final Charset sourceFileCharset;
    private final Collection<Path> srcDirectories;
    private final Collection<Path> testDirectories;

    private AnalyzerSettings(Charset sourceFileCharset, Collection<Path> srcDirectories, Collection<Path> testDirectories) {
        this.sourceFileCharset = sourceFileCharset;
        this.srcDirectories = srcDirectories;
        this.testDirectories = testDirectories;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Charset getSourceFileCharset() {
        return this.sourceFileCharset;
    }

    public Collection<Path> getSrcDirectories() {
        return this.srcDirectories;
    }

    public Collection<Path> getTestDirectories() {
        return this.testDirectories;
    }

    public Collection<Path> getAllDirectories() {
        HashSet<Path> result = new HashSet<Path>(this.srcDirectories.size() + this.testDirectories.size());
        result.addAll(this.srcDirectories);
        result.addAll(this.testDirectories);
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.sourceFileCharset, this.srcDirectories, this.testDirectories);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AnalyzerSettings && Objects.equals(this.sourceFileCharset, ((AnalyzerSettings)obj).sourceFileCharset) && Objects.equals(this.srcDirectories, ((AnalyzerSettings)obj).srcDirectories) && Objects.equals(this.testDirectories, ((AnalyzerSettings)obj).testDirectories);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sourceFileCharset", (Object)this.sourceFileCharset).add("srcDirectories", this.srcDirectories).add("testDirectories", this.testDirectories).toString();
    }

    public static final class Builder {
        private final List<Path> srcDirectories = new ArrayList<Path>();
        private final List<Path> testDirectories = new ArrayList<Path>();
        private Charset sourceFileCharset = Charset.defaultCharset();

        private Builder() {
        }

        public Builder withSrcDirectories(Collection<Path> srcDirectories) {
            this.srcDirectories.addAll(srcDirectories);
            return this;
        }

        public Builder withSrcDirectories(Path ... srcDirectories) {
            this.srcDirectories.addAll(Arrays.asList(srcDirectories));
            return this;
        }

        public Builder withTestDirectories(Collection<Path> testDirectories) {
            this.testDirectories.addAll(testDirectories);
            return this;
        }

        public Builder withTestDirectories(Path ... testDirectories) {
            this.testDirectories.addAll(Arrays.asList(testDirectories));
            return this;
        }

        public Builder withSourceFileCharset(Charset sourceFileCharset) {
            this.sourceFileCharset = sourceFileCharset;
            return this;
        }

        public AnalyzerSettings build() {
            return new AnalyzerSettings(this.sourceFileCharset, this.srcDirectories, this.testDirectories);
        }
    }
}

