/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import com.google.common.base.MoreObjects;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class AnalyzeResult {
    private final List<MatchedFile> srcMatches;
    private final List<MatchedFile> testMatches;
    private final long duration;

    private AnalyzeResult(List<MatchedFile> srcMatches, List<MatchedFile> testMatches, long duration) {
        this.srcMatches = srcMatches;
        this.testMatches = testMatches;
        this.duration = duration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<MatchedFile> getSrcMatches() {
        return this.srcMatches;
    }

    public Map<BannedImportGroup, List<MatchedFile>> srcMatchesByGroup() {
        return this.srcMatches.stream().collect(Collectors.groupingBy(MatchedFile::getMatchedBy));
    }

    public List<MatchedFile> getTestMatches() {
        return this.testMatches;
    }

    public Map<BannedImportGroup, List<MatchedFile>> testMatchesByGroup() {
        return this.testMatches.stream().collect(Collectors.groupingBy(MatchedFile::getMatchedBy));
    }

    public boolean bannedImportsFound() {
        return this.bannedImportsInCompileCode() || this.bannedImportsInTestCode();
    }

    public boolean bannedImportsInCompileCode() {
        return !this.srcMatches.isEmpty();
    }

    public boolean bannedImportsInTestCode() {
        return !this.testMatches.isEmpty();
    }

    public long getDuration() {
        return this.duration;
    }

    public int hashCode() {
        return Objects.hash(this.srcMatches, this.testMatches);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AnalyzeResult && Objects.equals(this.srcMatches, ((AnalyzeResult)obj).srcMatches) && Objects.equals(this.testMatches, ((AnalyzeResult)obj).testMatches);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("srcMatches", this.srcMatches).add("testMatches", this.testMatches).add("duration", this.duration).toString();
    }

    public static class Builder {
        private final List<MatchedFile> srcMatches = new ArrayList<MatchedFile>();
        private final List<MatchedFile> testMatches = new ArrayList<MatchedFile>();
        private long duration;

        private Builder() {
        }

        public Builder withMatches(Collection<MatchedFile> matches) {
            this.srcMatches.addAll(matches);
            return this;
        }

        public Builder withMatches(MatchedFile.Builder ... matches) {
            Arrays.stream(matches).map(MatchedFile.Builder::build).forEach(this.srcMatches::add);
            return this;
        }

        public Builder withMatchesInTestCode(Collection<MatchedFile> matches) {
            this.testMatches.addAll(matches);
            return this;
        }

        public Builder withMatchesInTestCode(MatchedFile.Builder ... matches) {
            Arrays.stream(matches).map(MatchedFile.Builder::build).forEach(this.testMatches::add);
            return this;
        }

        public Builder withDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public AnalyzeResult build() {
            return new AnalyzeResult(this.srcMatches, this.testMatches, this.duration);
        }
    }
}

