/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import com.google.common.base.MoreObjects;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class AnalyzeResult {
    private final List<MatchedFile> fileMatches;

    private AnalyzeResult(List<MatchedFile> matches) {
        this.fileMatches = matches;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<MatchedFile> getFileMatches() {
        return this.fileMatches;
    }

    public boolean bannedImportsFound() {
        return !this.fileMatches.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.fileMatches);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AnalyzeResult && Objects.equals(this.fileMatches, ((AnalyzeResult)obj).fileMatches);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fileMatches", this.fileMatches).toString();
    }

    public static class Builder {
        private final List<MatchedFile> matches = new ArrayList<MatchedFile>();

        private Builder() {
        }

        public Builder withMatches(Collection<MatchedFile> matches) {
            this.matches.addAll(matches);
            return this;
        }

        public Builder withMatches(MatchedFile.Builder ... matches) {
            Arrays.stream(matches).map(MatchedFile.Builder::build).forEach(this.matches::add);
            return this;
        }

        public AnalyzeResult build() {
            return new AnalyzeResult(this.matches);
        }
    }
}

