/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.types;

import de.flapdoodle.types.Pair;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="Pair", generator="Immutables")
public final class ImmutablePair<FIRST, SECOND>
extends Pair<FIRST, SECOND> {
    private final FIRST first;
    private final SECOND second;

    private ImmutablePair(FIRST first, SECOND second) {
        this.first = Objects.requireNonNull(first, "first");
        this.second = Objects.requireNonNull(second, "second");
    }

    private ImmutablePair(ImmutablePair<FIRST, SECOND> original, FIRST first, SECOND second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public FIRST first() {
        return this.first;
    }

    @Override
    public SECOND second() {
        return this.second;
    }

    public final ImmutablePair<FIRST, SECOND> withFirst(FIRST value) {
        if (this.first == value) {
            return this;
        }
        FIRST newValue = Objects.requireNonNull(value, "first");
        return new ImmutablePair<FIRST, SECOND>(this, newValue, this.second);
    }

    public final ImmutablePair<FIRST, SECOND> withSecond(SECOND value) {
        if (this.second == value) {
            return this;
        }
        SECOND newValue = Objects.requireNonNull(value, "second");
        return new ImmutablePair<FIRST, SECOND>(this, this.first, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePair && this.equalTo(0, (ImmutablePair)another);
    }

    private boolean equalTo(int synthetic, ImmutablePair<?, ?> another) {
        return this.first.equals(another.first) && this.second.equals(another.second);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.first.hashCode();
        h += (h << 5) + this.second.hashCode();
        return h;
    }

    public String toString() {
        return "Pair{first=" + this.first + ", second=" + this.second + "}";
    }

    public static <FIRST, SECOND> ImmutablePair<FIRST, SECOND> of(FIRST first, SECOND second) {
        return new ImmutablePair<FIRST, SECOND>(first, second);
    }

    public static <FIRST, SECOND> ImmutablePair<FIRST, SECOND> copyOf(Pair<FIRST, SECOND> instance) {
        if (instance instanceof ImmutablePair) {
            return (ImmutablePair)instance;
        }
        return ImmutablePair.builder().from(instance).build();
    }

    public static <FIRST, SECOND> Builder<FIRST, SECOND> builder() {
        return new Builder();
    }

    @Generated(from="Pair", generator="Immutables")
    public static final class Builder<FIRST, SECOND> {
        private static final long INIT_BIT_FIRST = 1L;
        private static final long INIT_BIT_SECOND = 2L;
        private long initBits = 3L;
        private FIRST first;
        private SECOND second;

        private Builder() {
        }

        public final Builder<FIRST, SECOND> from(Pair<FIRST, SECOND> instance) {
            Objects.requireNonNull(instance, "instance");
            this.first(instance.first());
            this.second(instance.second());
            return this;
        }

        public final Builder<FIRST, SECOND> first(FIRST first) {
            this.first = Objects.requireNonNull(first, "first");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<FIRST, SECOND> second(SECOND second) {
            this.second = Objects.requireNonNull(second, "second");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePair<FIRST, SECOND> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePair(null, this.first, this.second);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("first");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("second");
            }
            return "Cannot build Pair, some of required attributes are not set " + attributes;
        }
    }
}

