/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.graph;

import de.flapdoodle.graph.GraphAsDot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jgrapht.Graph;

@Generated(from="GraphAsDot.SubGraph", generator="Immutables")
public final class ImmutableSubGraph<T>
implements GraphAsDot.SubGraph<T> {
    private final Graph<T, ?> graph;
    private final Map<T, T> connections;

    private ImmutableSubGraph(Graph<T, ?> graph, Map<T, T> connections) {
        this.graph = graph;
        this.connections = connections;
    }

    @Override
    public Graph<T, ?> graph() {
        return this.graph;
    }

    @Override
    public Map<T, T> connections() {
        return this.connections;
    }

    public final ImmutableSubGraph<T> withGraph(Graph<T, ?> value) {
        if (this.graph == value) {
            return this;
        }
        Graph<T, ?> newValue = Objects.requireNonNull(value, "graph");
        return new ImmutableSubGraph<T>(newValue, this.connections);
    }

    public final ImmutableSubGraph<T> withConnections(Map<? extends T, ? extends T> entries) {
        if (this.connections == entries) {
            return this;
        }
        Map<? extends T, ? extends T> newValue = ImmutableSubGraph.createUnmodifiableMap(true, false, entries);
        return new ImmutableSubGraph<T>(this.graph, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSubGraph && this.equalTo(0, (ImmutableSubGraph)another);
    }

    private boolean equalTo(int synthetic, ImmutableSubGraph<?> another) {
        return this.graph.equals(another.graph) && this.connections.equals(another.connections);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.graph.hashCode();
        h += (h << 5) + this.connections.hashCode();
        return h;
    }

    public String toString() {
        return "SubGraph{graph=" + this.graph + ", connections=" + this.connections + "}";
    }

    public static <T> ImmutableSubGraph<T> copyOf(GraphAsDot.SubGraph<T> instance) {
        if (instance instanceof ImmutableSubGraph) {
            return (ImmutableSubGraph)instance;
        }
        return ImmutableSubGraph.builder().from(instance).build();
    }

    public static <T> Builder<T> builder(Graph<T, ?> graph) {
        return new Builder(graph);
    }

    static <T> Builder<T> builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="GraphAsDot.SubGraph", generator="Immutables")
    public static final class Builder<T> {
        private static final long INIT_BIT_GRAPH = 1L;
        private long initBits = 1L;
        private Graph<T, ?> graph;
        private Map<T, T> connections = new LinkedHashMap<T, T>();

        private Builder(Graph<T, ?> graph) {
            this.graph(graph);
        }

        private Builder() {
        }

        public final Builder<T> from(GraphAsDot.SubGraph<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.graph(instance.graph());
            this.putAllConnections(instance.connections());
            return this;
        }

        final Builder<T> graph(Graph<T, ?> graph) {
            this.graph = Objects.requireNonNull(graph, "graph");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<T> putConnections(T key, T value) {
            this.connections.put(Objects.requireNonNull(key, "connections key"), value == null ? Objects.requireNonNull(value, "connections value for key: " + key) : value);
            return this;
        }

        public final Builder<T> putConnections(Map.Entry<? extends T, ? extends T> entry) {
            T k = entry.getKey();
            T v = entry.getValue();
            this.connections.put(Objects.requireNonNull(k, "connections key"), v == null ? Objects.requireNonNull(v, "connections value for key: " + k) : v);
            return this;
        }

        public final Builder<T> connections(Map<? extends T, ? extends T> entries) {
            this.connections.clear();
            return this.putAllConnections(entries);
        }

        public final Builder<T> putAllConnections(Map<? extends T, ? extends T> entries) {
            for (Map.Entry<T, T> e : entries.entrySet()) {
                T k = e.getKey();
                T v = e.getValue();
                this.connections.put(Objects.requireNonNull(k, "connections key"), v == null ? Objects.requireNonNull(v, "connections value for key: " + k) : v);
            }
            return this;
        }

        public ImmutableSubGraph<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSubGraph(this.graph, ImmutableSubGraph.createUnmodifiableMap(false, false, this.connections));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("graph");
            }
            return "Cannot build SubGraph, some of required attributes are not set " + attributes;
        }
    }
}

