/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.types;

import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.embed.process.types.RunningProcess;
import de.flapdoodle.types.Try;
import java.nio.file.Files;
import java.nio.file.Path;

public class RunningProcessImpl
implements RunningProcess {
    private final ProcessControl process;
    private final Path pidFile;
    private final long timeout;
    private final Runnable onStop;

    public RunningProcessImpl(ProcessControl process, Path pidFile, long timeout, Runnable onStop) {
        this.process = process;
        this.pidFile = pidFile;
        this.timeout = timeout;
        this.onStop = onStop;
    }

    public RunningProcessImpl(ProcessControl process, ProcessOutput processOutput, Path pidFile, long timeout) {
        this(process, pidFile, timeout, RunningProcess.connectIOTo(process, processOutput));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stop() {
        try {
            int n = this.process.stop(this.timeout);
            return n;
        }
        finally {
            try {
                this.onStop.run();
            }
            finally {
                Try.runable(() -> Files.delete(this.pidFile)).mapException(RuntimeException::new).run();
            }
        }
    }

    public boolean isAlive() {
        return this.process.isAlive();
    }
}

