/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.model.types;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.webcohesion.enunciate.javac.decorations.Annotations;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.modules.jackson.EnunciateJacksonContext;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.adapters.AdapterType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonArrayType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonClassType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonMapType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonPrimitiveType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;
import com.webcohesion.enunciate.modules.jackson.model.types.KnownJsonType;
import com.webcohesion.enunciate.modules.jackson.model.util.JacksonUtil;
import com.webcohesion.enunciate.modules.jackson.model.util.MapType;
import com.webcohesion.enunciate.util.TypeHintUtils;
import java.util.LinkedList;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;

public class JsonTypeVisitor
extends SimpleTypeVisitor6<JsonType, Context> {
    @Override
    protected JsonType defaultAction(TypeMirror typeMirror, Context context) {
        return KnownJsonType.OBJECT;
    }

    @Override
    public JsonType visitPrimitive(PrimitiveType primitiveType, Context context) {
        if (context.isInArray() && primitiveType.getKind() == TypeKind.BYTE) {
            return KnownJsonType.STRING;
        }
        JsonPrimitiveType jsonType = new JsonPrimitiveType(primitiveType);
        return this.wrapAsNeeded(jsonType, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonType visitDeclared(DeclaredType declaredType, Context context) {
        String fqn;
        JsonType jsonType = null;
        Element declaredElement = declaredType.asElement();
        DecoratedProcessingEnvironment env = context.getContext().getContext().getProcessingEnvironment();
        DecoratedTypeMirror decoratedTypeMirror = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)declaredType, (DecoratedProcessingEnvironment)env);
        String string = fqn = declaredElement instanceof TypeElement ? ((TypeElement)declaredElement).getQualifiedName().toString() : declaredType.toString();
        if (context.getStack().contains(fqn) && !decoratedTypeMirror.isCollection() && !decoratedTypeMirror.isStream()) {
            return this.wrapAsNeeded(KnownJsonType.OBJECT, context);
        }
        context.getStack().push(fqn);
        try {
            AdapterType adapterType;
            JsonSerialize serializeInfo;
            TypeMirror hint;
            TypeHint typeHint = declaredElement.getAnnotation(TypeHint.class);
            if (typeHint != null && (hint = TypeHintUtils.getTypeHint((TypeHint)typeHint, (DecoratedProcessingEnvironment)context.getContext().getContext().getProcessingEnvironment(), null)) != null) {
                jsonType = hint.accept(this, new Context(context.context, false, false, context.stack));
            }
            if ((serializeInfo = declaredElement.getAnnotation(JsonSerialize.class)) != null) {
                DecoratedTypeMirror as;
                DecoratedTypeMirror using = Annotations.mirrorOf(() -> ((JsonSerialize)serializeInfo).using(), (DecoratedProcessingEnvironment)env, JsonSerializer.None.class);
                if (using != null) {
                    jsonType = KnownJsonType.OBJECT;
                }
                if ((as = Annotations.mirrorOf(() -> ((JsonSerialize)serializeInfo).as(), (DecoratedProcessingEnvironment)env, Void.class)) != null) {
                    jsonType = (JsonType)as.accept((TypeVisitor)this, (Object)new Context(context.context, false, false, context.stack));
                }
            }
            if ((adapterType = JacksonUtil.findAdapterType(declaredElement, context.getContext())) != null) {
                adapterType.getAdaptingType().accept(this, new Context(context.context, false, false, context.stack));
            } else {
                MapType mapType = MapType.findMapType(declaredType, context.getContext());
                if (mapType != null) {
                    JsonType keyType = mapType.getKeyType().accept(this, new Context(context.getContext(), false, false, context.stack));
                    JsonType valueType = mapType.getValueType().accept(this, new Context(context.getContext(), false, false, context.stack));
                    jsonType = new JsonMapType(keyType, valueType);
                } else {
                    DecoratedTypeMirror componentType = TypeMirrorUtils.getComponentType((DecoratedTypeMirror)decoratedTypeMirror, (DecoratedProcessingEnvironment)env);
                    if (componentType != null) {
                        JsonType valueType = this.wrapAsNeeded(componentType.accept(this, new Context(context.context, false, true, context.stack)), context);
                        return valueType;
                    }
                    switch (declaredElement.getKind()) {
                        case ENUM: 
                        case CLASS: 
                        case INTERFACE: 
                        case RECORD: {
                            JsonType knownType = context.getContext().getKnownType(declaredElement);
                            if (knownType != null) {
                                jsonType = knownType;
                                break;
                            }
                            TypeDefinition typeDefinition = context.getContext().findTypeDefinition(declaredElement);
                            if (typeDefinition == null) break;
                            jsonType = new JsonClassType(typeDefinition);
                        }
                    }
                }
            }
            if (jsonType == null) {
                jsonType = (JsonType)super.visitDeclared(declaredType, context);
            }
            JsonType jsonType2 = this.wrapAsNeeded(jsonType, context);
            return jsonType2;
        }
        finally {
            context.getStack().pop();
        }
    }

    private JsonType wrapAsNeeded(JsonType jsonType, Context context) {
        return context.isInArray() || context.isInCollection() ? new JsonArrayType(jsonType) : jsonType;
    }

    @Override
    public JsonType visitArray(ArrayType arrayType, Context context) {
        TypeMirror componentType = arrayType.getComponentType();
        return this.wrapAsNeeded(componentType.accept(this, new Context(context.context, true, false, context.stack)), context);
    }

    @Override
    public JsonType visitTypeVariable(TypeVariable typeVariable, Context context) {
        TypeMirror bound = typeVariable.getUpperBound();
        if (bound == null) {
            return this.wrapAsNeeded(KnownJsonType.OBJECT, context);
        }
        JsonType jsonType = bound.accept(this, new Context(context.context, false, false, context.stack));
        return this.wrapAsNeeded(jsonType, context);
    }

    @Override
    public JsonType visitWildcard(WildcardType wildcardType, Context context) {
        TypeMirror bound = wildcardType.getExtendsBound();
        if (bound == null) {
            return this.wrapAsNeeded(KnownJsonType.OBJECT, context);
        }
        JsonType jsonType = bound.accept(this, new Context(context.context, false, false, context.stack));
        return this.wrapAsNeeded(jsonType, context);
    }

    public static class Context {
        private final EnunciateJacksonContext context;
        private final boolean inArray;
        private final boolean inCollection;
        private final LinkedList<String> stack;

        public Context(EnunciateJacksonContext context, boolean inArray, boolean inCollection, LinkedList<String> stack) {
            this.context = context;
            this.inArray = inArray;
            this.inCollection = inCollection;
            this.stack = stack;
        }

        public EnunciateJacksonContext getContext() {
            return this.context;
        }

        public boolean isInArray() {
            return this.inArray;
        }

        public boolean isInCollection() {
            return this.inCollection;
        }

        public LinkedList<String> getStack() {
            return this.stack;
        }
    }
}

