/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.modules.jackson.EnunciateJacksonContext;
import com.webcohesion.enunciate.modules.jackson.model.EnumValue;
import com.webcohesion.enunciate.modules.jackson.model.SimpleTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;
import com.webcohesion.enunciate.modules.jackson.model.types.KnownJsonType;
import com.webcohesion.enunciate.modules.jackson.model.util.JacksonUtil;
import com.webcohesion.enunciate.util.AnnotationUtils;
import jakarta.xml.bind.annotation.XmlEnumValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class EnumTypeDefinition
extends SimpleTypeDefinition {
    private List<EnumValue> enumValues;
    private KnownJsonType baseType;

    public EnumTypeDefinition(TypeElement delegate, EnunciateJacksonContext context) {
        super(delegate, context);
        this.baseType = this.loadBaseType(delegate);
    }

    protected KnownJsonType loadBaseType(TypeElement delegate) {
        KnownJsonType baseType = KnownJsonType.STRING;
        for (ExecutableElement method : ElementFilter.methodsIn(delegate.getEnclosedElements())) {
            JsonValue jsonValue = method.getAnnotation(JsonValue.class);
            if (jsonValue == null || !jsonValue.value()) continue;
            TypeMirror returnType = method.getReturnType();
            switch (returnType.getKind()) {
                case BOOLEAN: {
                    baseType = KnownJsonType.BOOLEAN;
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    baseType = KnownJsonType.NUMBER;
                    break;
                }
                case INT: 
                case LONG: 
                case SHORT: 
                case BYTE: {
                    baseType = KnownJsonType.WHOLE_NUMBER;
                }
            }
            break;
        }
        return baseType;
    }

    protected List<EnumValue> loadEnumValues() {
        List enumConstants = this.enumValues();
        ArrayList<EnumValue> enumValueMap = new ArrayList<EnumValue>();
        HashSet<String> enumValues = new HashSet<String>(enumConstants.size());
        for (VariableElement enumConstant : enumConstants) {
            JsonProperty jsonProperty;
            AnnotationValue av;
            XmlEnumValue enumValue;
            if (AnnotationUtils.isIgnored((Element)enumConstant)) continue;
            String value = enumConstant.getSimpleName().toString();
            if (this.context.isHonorJaxb() && (enumValue = enumConstant.getAnnotation(XmlEnumValue.class)) != null) {
                value = enumValue.value();
            }
            if (this.context.isHonorGson() && (av = JacksonUtil.findAnnotationValueByName(JacksonUtil.findAnnotationByClassName(enumConstant.getAnnotationMirrors(), "com.google.gson.annotations.SerializedName"), "value")) != null) {
                value = (String)av.getValue();
            }
            if ((jsonProperty = enumConstant.getAnnotation(JsonProperty.class)) != null) {
                value = jsonProperty.value();
            }
            if (!enumValues.add(value)) {
                throw new EnunciateException(this.getQualifiedName() + ": duplicate enum value: " + value);
            }
            enumValueMap.add(new EnumValue(this, enumConstant, enumConstant.getSimpleName().toString(), value));
        }
        return enumValueMap;
    }

    @Override
    public JsonType getBaseType() {
        return this.baseType;
    }

    public List<EnumValue> getEnumValues() {
        if (this.enumValues == null) {
            this.enumValues = this.loadEnumValues();
        }
        return this.enumValues;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return true;
    }
}

