/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.api.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.datatype.BaseType;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.api.datatype.Property;
import com.webcohesion.enunciate.api.datatype.Value;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeExampleImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeReferenceImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.PropertyImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.TypeReferencePropertyImpl;
import com.webcohesion.enunciate.modules.jackson.model.Member;
import com.webcohesion.enunciate.modules.jackson.model.ObjectTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonClassType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonTypeFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class ObjectDataTypeImpl
extends DataTypeImpl {
    final ObjectTypeDefinition typeDefinition;

    public ObjectDataTypeImpl(ObjectTypeDefinition typeDefinition, ApiRegistrationContext registrationContext) {
        super(typeDefinition, registrationContext);
        this.typeDefinition = typeDefinition;
    }

    public BaseType getBaseType() {
        return BaseType.object;
    }

    public Value findValue(String name) {
        return null;
    }

    public List<? extends Value> getValues() {
        return null;
    }

    public Property findProperty(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (Member member : this.typeDefinition.getMembers()) {
            if (!member.getSimpleName().contentEquals(name)) continue;
            return new PropertyImpl(member, this.registrationContext);
        }
        return null;
    }

    public List<? extends Property> getProperties() {
        ArrayList<Object> properties;
        List<Member> members = this.typeDefinition.getMembers();
        if (this.typeDefinition.getTypeIdInclusion() == JsonTypeInfo.As.PROPERTY) {
            properties = new ArrayList(members.size() + 1);
            if (this.typeDefinition.getTypeIdProperty() != null && members.stream().noneMatch(m -> this.typeDefinition.getTypeIdProperty().equals(m.getName()))) {
                properties.add(new TypeReferencePropertyImpl(this.typeDefinition.getTypeIdProperty()));
            }
        } else {
            properties = new ArrayList<Object>(members.size());
        }
        FacetFilter facetFilter = this.registrationContext.getFacetFilter();
        for (Member member : members) {
            if (!facetFilter.accept((HasFacets)member)) continue;
            if (member.getChoices().size() > 1) {
                JsonTypeInfo.As inclusion = member.getSubtypeIdInclusion();
                if (inclusion == JsonTypeInfo.As.WRAPPER_ARRAY || inclusion == JsonTypeInfo.As.WRAPPER_OBJECT) {
                    for (Member member2 : member.getChoices()) {
                        properties.add(new PropertyImpl(member2, this.registrationContext, member.isCollectionType()));
                    }
                    continue;
                }
                properties.add(new PropertyImpl(member, this.registrationContext));
                continue;
            }
            properties.add(new PropertyImpl(member, this.registrationContext));
        }
        return properties;
    }

    public List<? extends Property> getRequiredProperties() {
        ArrayList<Property> requiredProperties = new ArrayList<Property>();
        for (Property property : this.getProperties()) {
            if (!property.isRequired()) continue;
            requiredProperties.add(property);
        }
        return requiredProperties;
    }

    @Override
    public List<DataTypeReference> getSupertypes() {
        ArrayList<DataTypeReferenceImpl> supertypes = null;
        JsonType supertype = this.typeDefinition.getSupertype();
        while (supertype != null) {
            if (supertypes == null) {
                supertypes = new ArrayList<DataTypeReferenceImpl>();
            }
            supertypes.add(new DataTypeReferenceImpl(supertype, this.registrationContext));
            supertype = supertype instanceof JsonClassType ? (((JsonClassType)supertype).getTypeDefinition() instanceof ObjectTypeDefinition ? ((ObjectTypeDefinition)((JsonClassType)supertype).getTypeDefinition()).getSupertype() : null) : null;
        }
        return supertypes;
    }

    @Override
    public Set<DataTypeReference> getInterfaces() {
        TreeSet<DataTypeReference> interfaces = new TreeSet<DataTypeReference>(new Comparator<DataTypeReference>(){

            @Override
            public int compare(DataTypeReference o1, DataTypeReference o2) {
                return o1.getSlug().compareTo(o2.getSlug());
            }
        });
        this.gatherInterfaces((TypeElement)((Object)this.typeDefinition), interfaces);
        return interfaces.isEmpty() ? null : interfaces;
    }

    private void gatherInterfaces(TypeElement clazz, Set<DataTypeReference> interfaces) {
        if (clazz == null) {
            return;
        }
        if (clazz.getQualifiedName().contentEquals(Object.class.getName())) {
            return;
        }
        List<? extends TypeMirror> ifaces = clazz.getInterfaces();
        for (TypeMirror typeMirror : ifaces) {
            DecoratedTypeMirror decorated = (DecoratedTypeMirror)typeMirror;
            decorated = this.typeDefinition.getContext().resolveSyntheticType(decorated);
            TypeDefinition typeDefinition = this.typeDefinition.getContext().findTypeDefinition(((DeclaredType)decorated).asElement());
            if (typeDefinition == null) continue;
            interfaces.add(new DataTypeReferenceImpl(new JsonClassType(typeDefinition), this.registrationContext));
        }
        TypeMirror superclass = clazz.getSuperclass();
        if (superclass instanceof DeclaredType) {
            this.gatherInterfaces((TypeElement)((DeclaredType)superclass).asElement(), interfaces);
        }
    }

    @Override
    public List<DataTypeReference> getSubtypes() {
        ArrayList<DataTypeReference> subtypes = new ArrayList<DataTypeReference>();
        for (TypeDefinition td : this.typeDefinition.getContext().getTypeDefinitions()) {
            if (!(td instanceof ObjectTypeDefinition) || td.getQualifiedName().contentEquals(this.typeDefinition.getQualifiedName()) || !((DecoratedTypeMirror)td.asType()).isInstanceOf((Element)((Object)this.typeDefinition))) continue;
            subtypes.add(new DataTypeReferenceImpl(JsonTypeFactory.getJsonType(td.asType(), this.typeDefinition.getContext()), this.registrationContext));
        }
        return subtypes.isEmpty() ? null : subtypes;
    }

    @Override
    public Example getExample() {
        return this.typeDefinition.getContext().isDisableExamples() ? null : new DataTypeExampleImpl(this.typeDefinition, this.registrationContext);
    }

    public String getTypeIdProperty() {
        String typeIdProperty = null;
        if (this.typeDefinition.isHasTypeInfo() && this.typeDefinition.getTypeIdInclusion() == JsonTypeInfo.As.PROPERTY && (typeIdProperty = this.typeDefinition.getTypeIdProperty()) == null) {
            typeIdProperty = this.typeDefinition.getTypeIdType().getDefaultPropertyName();
        }
        return typeIdProperty;
    }
}

