/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.datatype.BaseType;
import com.webcohesion.enunciate.api.datatype.Property;
import com.webcohesion.enunciate.api.datatype.Value;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.ValueImpl;
import com.webcohesion.enunciate.modules.jackson.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.EnumValue;
import com.webcohesion.enunciate.util.Memoized;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.lang.model.element.Element;

public class EnumDataTypeImpl
extends DataTypeImpl {
    private final EnumTypeDefinition typeDefinition;

    public EnumDataTypeImpl(EnumTypeDefinition typeDefinition, ApiRegistrationContext registrationContext) {
        super(typeDefinition, registrationContext);
        this.typeDefinition = typeDefinition;
    }

    public BaseType getBaseType() {
        return BaseType.string;
    }

    public Value findValue(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (EnumValue enumValue : this.typeDefinition.getEnumValues()) {
            if (!name.equals(enumValue.getName())) continue;
            return this.createValue(enumValue);
        }
        return null;
    }

    public List<? extends Value> getValues() {
        FacetFilter facetFilter = this.registrationContext.getFacetFilter();
        List<EnumValue> enumValues = this.typeDefinition.getEnumValues();
        ArrayList<ValueImpl> values = new ArrayList<ValueImpl>(enumValues.size());
        for (EnumValue enumValue : enumValues) {
            if (enumValue.getValue() == null || !facetFilter.accept((HasFacets)enumValue)) continue;
            values.add(this.createValue(enumValue));
        }
        return values;
    }

    private ValueImpl createValue(EnumValue enumValue) {
        return new ValueImpl(enumValue.getValue(), (Supplier<JavaDoc>)new Memoized(() -> enumValue.getJavaDoc(this.registrationContext.getTagHandler())), Styles.gatherStyles((Element)((Object)enumValue), (Map)this.typeDefinition.getContext().getContext().getConfiguration().getAnnotationStyles()), enumValue.getFacets());
    }

    public Property findProperty(String name) {
        return null;
    }

    public List<? extends Property> getProperties() {
        return null;
    }
}

