/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.docs;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.ApiRegistry;
import com.webcohesion.enunciate.api.datatype.DataType;
import com.webcohesion.enunciate.api.datatype.Property;
import com.webcohesion.enunciate.api.datatype.Value;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.ResourceApi;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.api.services.Operation;
import com.webcohesion.enunciate.api.services.Service;
import com.webcohesion.enunciate.api.services.ServiceApi;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedPackageElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.javac.javadoc.JavaDocLink;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

public class ApiDocsJavaDocTagHandler
implements JavaDocTagHandler {
    static final Pattern RAW_LINK_PATTERN = Pattern.compile("(?:^|[^>=\"'])(http.[^\"'<\\s]+)(?![^<>]*>|[^\"]*?<\\/a)");
    private final ApiRegistry registry;
    private final ApiRegistrationContext context;

    public ApiDocsJavaDocTagHandler(ApiRegistry registry, ApiRegistrationContext context) {
        this.registry = registry;
        this.context = context;
    }

    public String getTypeId() {
        return "api-docs";
    }

    public String onInlineTag(String tagName, String tagText, DecoratedElement context) {
        if ("link".equals(tagName)) {
            JavaDocLink link = JavaDocLink.parse((String)tagText);
            String classRef = link.getClassName();
            String subelementRef = link.getMemberName();
            String value = link.getLabel();
            if ("".equals(classRef)) {
                for (DecoratedElement type = context; type != null && !(type instanceof PackageElement); type = (DecoratedElement)type.getEnclosingElement()) {
                    if (!(type instanceof DecoratedTypeElement)) continue;
                    classRef = ((DecoratedTypeElement)type).getQualifiedName().toString();
                    break;
                }
            }
            ArrayList<String> possibleResolutions = new ArrayList<String>();
            if (!"".equals(classRef)) {
                if (classRef.indexOf(46) < 0) {
                    for (DecoratedElement pckg = context; pckg != null; pckg = (DecoratedElement)pckg.getEnclosingElement()) {
                        if (pckg instanceof TypeElement) {
                            possibleResolutions.add(((TypeElement)pckg).getQualifiedName().toString() + "." + classRef);
                            continue;
                        }
                        if (!(pckg instanceof DecoratedPackageElement)) continue;
                        possibleResolutions.add(((DecoratedPackageElement)pckg).getQualifiedName() + "." + classRef);
                        break;
                    }
                } else {
                    possibleResolutions.add(classRef);
                }
            }
            return this.resolveJavadocLink(possibleResolutions, tagText, subelementRef, value);
        }
        if ("code".equals(tagName)) {
            return "<code>" + tagText + "</code>";
        }
        return tagText;
    }

    private String resolveJavadocLink(List<String> possibleResolutions, String tagText, String subelementRef, String value) {
        if (!possibleResolutions.isEmpty()) {
            Set syntaxes = this.registry.getSyntaxes(this.context);
            for (Object syntax : syntaxes) {
                for (String string : possibleResolutions) {
                    List dataTypes = syntax.findDataTypes(string);
                    if (dataTypes == null || dataTypes.isEmpty()) continue;
                    DataType dataType = (DataType)dataTypes.get(0);
                    Value dataTypeValue = dataType.findValue(subelementRef);
                    if (dataTypeValue != null) {
                        return "<a href=\"" + dataType.getSlug() + ".html#" + dataTypeValue.getValue() + "\">" + (String)(value != null ? value : dataTypeValue.getValue()) + "</a>";
                    }
                    Property property = dataType.findProperty(subelementRef);
                    if (property != null) {
                        return "<a href=\"" + dataType.getSlug() + ".html#prop-" + property.getName() + "\">" + (String)(value != null ? value : property.getName()) + "</a>";
                    }
                    return "<a href=\"" + dataType.getSlug() + ".html\">" + (String)(value != null ? value : (subelementRef.isEmpty() ? dataType.getLabel() : subelementRef)) + "</a>";
                }
            }
            List resourceApis = this.registry.getResourceApis(this.context);
            for (ResourceApi resourceApi : resourceApis) {
                for (String candidate : possibleResolutions) {
                    Method method = resourceApi.findMethodFor(candidate, subelementRef);
                    if (method != null) {
                        if (value == null) {
                            value = method.getLabel() + " " + method.getResource().getGroup().getLabel();
                        }
                        return "<a href=\"" + method.getResource().getGroup().getSlug() + ".html#" + method.getSlug() + "\">" + (String)value + "</a>";
                    }
                    ResourceGroup resourceGroup = resourceApi.findResourceGroupFor(candidate);
                    if (resourceGroup == null) continue;
                    if (value == null) {
                        value = resourceGroup.getLabel();
                    }
                    return "<a href=\"" + resourceGroup.getSlug() + ".html\">" + (String)value + "</a>";
                }
            }
            List serviceApis = this.registry.getServiceApis(this.context);
            for (ServiceApi serviceApi : serviceApis) {
                for (String candidate : possibleResolutions) {
                    Operation operation = serviceApi.findOperationFor(candidate, subelementRef);
                    if (operation != null) {
                        if (value == null) {
                            value = operation.getName();
                        }
                        return "<a href=\"" + operation.getService().getSlug() + ".html#" + operation.getSlug() + "\">" + (String)value + "</a>";
                    }
                    Service service = serviceApi.findServiceFor(candidate);
                    if (service == null) continue;
                    if (value == null) {
                        value = service.getLabel();
                    }
                    return "<a href=\"" + service.getSlug() + ".html\">" + (String)value + "</a>";
                }
            }
        }
        return value != null ? value : tagText.trim();
    }

    public String onBlockTag(String tagName, String value, DecoratedElement context) {
        if ("see".equals(tagName)) {
            if (value.startsWith("\"")) {
                return value;
            }
            if (value.startsWith("<")) {
                return value;
            }
            if (value.startsWith("http")) {
                return "<a target=\"_blank\" href=\"" + value + "\">" + value + "</a>";
            }
            return this.onInlineTag("link", value, context);
        }
        return RAW_LINK_PATTERN.matcher(value).replaceAll(" <a target=\"_blank\" href=\"$1\">$1</a>");
    }
}

