/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.model.object;

import com.volcengine.tos.internal.TosResponse;
import com.volcengine.tos.model.object.GetObjectBasicOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Deprecated
public class ObjectMeta {
    private long contentLength;
    private String contentType;
    private String contentMD5;
    private String contentLanguage;
    private String contentEncoding;
    private String contentDisposition;
    private String lastModified;
    private String cacheControl;
    private String expires;
    private String etags;
    private String versionID;
    private boolean deleteMarker;
    private String objectType;
    private String storageClass;
    private String restore;
    private Map<String, String> metadata;
    private String mirrorTag;
    private String sseCustomerAlgorithm;
    private String sseCustomerKeyMD5;
    private String csType;
    private String crc64;

    public ObjectMeta fromResponse(TosResponse res) {
        this.contentLength = res.getContentLength();
        this.contentType = res.getHeaderWithKeyIgnoreCase("Content-Type");
        this.contentMD5 = res.getHeaderWithKeyIgnoreCase("Content-MD5");
        this.contentLanguage = res.getHeaderWithKeyIgnoreCase("Content-Language");
        this.contentEncoding = res.getHeaderWithKeyIgnoreCase("Content-Encoding");
        this.contentDisposition = res.getHeaderWithKeyIgnoreCase("Content-Disposition");
        this.lastModified = res.getHeaderWithKeyIgnoreCase("Last-Modified");
        this.cacheControl = res.getHeaderWithKeyIgnoreCase("Cache-Control");
        this.expires = res.getHeaderWithKeyIgnoreCase("Expires");
        this.etags = res.getHeaderWithKeyIgnoreCase("ETag");
        this.versionID = res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id");
        this.deleteMarker = Boolean.parseBoolean(res.getHeaderWithKeyIgnoreCase("X-Tos-Delete-Marker"));
        this.objectType = res.getHeaderWithKeyIgnoreCase("X-Tos-Object-Type");
        this.storageClass = res.getHeaderWithKeyIgnoreCase("X-Tos-Storage-Class");
        this.restore = res.getHeaderWithKeyIgnoreCase("X-Tos-Restore");
        this.metadata = this.userMetadata(res.getHeaders());
        this.mirrorTag = res.getHeaderWithKeyIgnoreCase("X-Tos-Tag");
        this.sseCustomerAlgorithm = res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm");
        this.sseCustomerKeyMD5 = res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5");
        this.csType = res.getHeaderWithKeyIgnoreCase("X-Tos-Cs-Type");
        this.crc64 = res.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma");
        return this;
    }

    public ObjectMeta fromGetObjectV2Output(GetObjectBasicOutput res) {
        if (res == null) {
            return null;
        }
        this.contentLength = res.getContentLength();
        this.contentType = res.getContentType();
        this.contentMD5 = res.getContentMD5();
        this.contentLanguage = res.getContentLanguage();
        this.contentEncoding = res.getContentEncoding();
        this.contentDisposition = res.getContentDisposition();
        this.lastModified = res.getLastModified();
        this.cacheControl = res.getCacheControl();
        this.expires = res.getExpires();
        this.etags = res.getEtag();
        this.versionID = res.getVersionID();
        this.deleteMarker = res.isDeleteMarker();
        this.objectType = res.getObjectType();
        this.storageClass = res.getStorageClass().toString();
        this.metadata = res.getCustomMetadata();
        this.sseCustomerAlgorithm = res.getSsecAlgorithm();
        this.sseCustomerKeyMD5 = res.getSsecKeyMD5();
        this.crc64 = res.getHashCrc64ecma();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectMeta that = (ObjectMeta)o;
        return this.contentLength == that.contentLength && this.deleteMarker == that.deleteMarker && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.contentMD5, that.contentMD5) && Objects.equals(this.contentLanguage, that.contentLanguage) && Objects.equals(this.contentEncoding, that.contentEncoding) && Objects.equals(this.contentDisposition, that.contentDisposition) && Objects.equals(this.lastModified, that.lastModified) && Objects.equals(this.cacheControl, that.cacheControl) && Objects.equals(this.expires, that.expires) && Objects.equals(this.etags, that.etags) && Objects.equals(this.versionID, that.versionID) && Objects.equals(this.objectType, that.objectType) && Objects.equals(this.storageClass, that.storageClass) && Objects.equals(this.restore, that.restore) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.mirrorTag, that.mirrorTag) && Objects.equals(this.sseCustomerAlgorithm, that.sseCustomerAlgorithm) && Objects.equals(this.sseCustomerKeyMD5, that.sseCustomerKeyMD5) && Objects.equals(this.csType, that.csType);
    }

    public int hashCode() {
        return Objects.hash(this.contentLength, this.contentType, this.contentMD5, this.contentLanguage, this.contentEncoding, this.contentDisposition, this.lastModified, this.cacheControl, this.expires, this.etags, this.versionID, this.deleteMarker, this.objectType, this.storageClass, this.restore, this.metadata, this.mirrorTag, this.sseCustomerAlgorithm, this.sseCustomerKeyMD5, this.csType);
    }

    private Map<String, String> userMetadata(Map<String, String> headers) {
        HashMap<String, String> meta = new HashMap<String, String>();
        for (String key : headers.keySet()) {
            if (!key.startsWith("X-Tos-Meta-".toLowerCase())) continue;
            String kk = key.substring("X-Tos-Meta-".length());
            meta.put(kk, headers.get(key));
        }
        return meta;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public ObjectMeta setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ObjectMeta setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public ObjectMeta setContentMD5(String contentMD5) {
        this.contentMD5 = contentMD5;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public ObjectMeta setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public ObjectMeta setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public ObjectMeta setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public ObjectMeta setLastModified(String lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public ObjectMeta setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getExpires() {
        return this.expires;
    }

    public ObjectMeta setExpires(String expires) {
        this.expires = expires;
        return this;
    }

    public String getEtags() {
        return this.etags;
    }

    public ObjectMeta setEtags(String etags) {
        this.etags = etags;
        return this;
    }

    public String getVersionID() {
        return this.versionID;
    }

    public ObjectMeta setVersionID(String versionID) {
        this.versionID = versionID;
        return this;
    }

    public boolean isDeleteMarker() {
        return this.deleteMarker;
    }

    public ObjectMeta setDeleteMarker(boolean deleteMarker) {
        this.deleteMarker = deleteMarker;
        return this;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public ObjectMeta setObjectType(String objectType) {
        this.objectType = objectType;
        return this;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public ObjectMeta setStorageClass(String storageClass) {
        this.storageClass = storageClass;
        return this;
    }

    public String getRestore() {
        return this.restore;
    }

    public ObjectMeta setRestore(String restore) {
        this.restore = restore;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ObjectMeta setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getMirrorTag() {
        return this.mirrorTag;
    }

    public ObjectMeta setMirrorTag(String mirrorTag) {
        this.mirrorTag = mirrorTag;
        return this;
    }

    public String getSseCustomerAlgorithm() {
        return this.sseCustomerAlgorithm;
    }

    public ObjectMeta setSseCustomerAlgorithm(String sseCustomerAlgorithm) {
        this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        return this;
    }

    public String getSseCustomerKeyMD5() {
        return this.sseCustomerKeyMD5;
    }

    public ObjectMeta setSseCustomerKeyMD5(String sseCustomerKeyMD5) {
        this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        return this;
    }

    public String getCsType() {
        return this.csType;
    }

    public ObjectMeta setCsType(String csType) {
        this.csType = csType;
        return this;
    }

    public String getCrc64() {
        return this.crc64;
    }

    public ObjectMeta setCrc64(String crc64) {
        this.crc64 = crc64;
        return this;
    }

    public String toString() {
        return "ObjectMeta{contentLength=" + this.contentLength + ", contentType='" + this.contentType + '\'' + ", contentMD5='" + this.contentMD5 + '\'' + ", contentLanguage='" + this.contentLanguage + '\'' + ", contentEncoding='" + this.contentEncoding + '\'' + ", contentDisposition='" + this.contentDisposition + '\'' + ", lastModified='" + this.lastModified + '\'' + ", cacheControl='" + this.cacheControl + '\'' + ", expires='" + this.expires + '\'' + ", etags='" + this.etags + '\'' + ", versionID='" + this.versionID + '\'' + ", deleteMarker=" + this.deleteMarker + ", objectType='" + this.objectType + '\'' + ", storageClass='" + this.storageClass + '\'' + ", restore='" + this.restore + '\'' + ", metadata=" + this.metadata + ", mirrorTag='" + this.mirrorTag + '\'' + ", sseCustomerAlgorithm='" + this.sseCustomerAlgorithm + '\'' + ", sseCustomerKeyMD5='" + this.sseCustomerKeyMD5 + '\'' + ", csType='" + this.csType + '\'' + ", crc64=" + this.crc64 + '}';
    }
}

