/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.util.dnscache;

import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import com.volcengine.tos.internal.util.dnscache.DefaultDnsCacheService;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@Deprecated
class DnsCache {
    private String host;
    private volatile List<InetAddress> ipList;
    private volatile long lastUpdateTimeNanos;
    private AtomicReference<Integer> refreshing;

    DnsCache(String host, int timeoutMinutes) {
        ParamsChecker.ensureNotNull(host, "host");
        if (timeoutMinutes <= 0) {
            return;
        }
        this.host = host;
        this.refreshing = new AtomicReference<Integer>(1);
        this.addRefreshTask(this::refresh);
    }

    public List<InetAddress> getIpList() {
        if (this.refreshing.get() == 0) {
            if (this.ipList != null) {
                return this.ipList;
            }
            if (this.refreshing.compareAndSet(0, 1)) {
                this.addRefreshTask(this::refresh);
            }
        }
        return this.ipList;
    }

    public long getLastUpdateTimeNanos() {
        return this.lastUpdateTimeNanos;
    }

    public List<InetAddress> removeIp(String ip) {
        if (this.refreshing.get() == 1 || this.ipList == null || StringUtils.isEmpty(ip)) {
            return this.ipList;
        }
        if (this.refreshing.compareAndSet(0, 1)) {
            for (InetAddress addr : this.ipList) {
                if (!StringUtils.equals(addr.getHostAddress(), ip)) continue;
                this.ipList.remove(addr);
                break;
            }
            this.refreshing.set(0);
        }
        return this.ipList;
    }

    void addRefreshTask(Runnable action) {
        DefaultDnsCacheService.getInstance().submit(action);
    }

    void refresh() {
        try {
            this.ipList = new ArrayList<InetAddress>(Arrays.asList(InetAddress.getAllByName(this.host)));
            if (this.ipList.size() == 0) {
                TosUtils.getLogger().debug("tos: host {} look up 0 address.", (Object)this.host);
            }
            this.lastUpdateTimeNanos = System.nanoTime();
        }
        catch (Exception e) {
            TosUtils.getLogger().debug("tos: host {} look up address failed, exception is {}.", (Object)this.host, (Object)e.toString());
        }
        finally {
            this.refreshing.set(0);
        }
    }
}

