/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.model;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.comm.io.Retryable;
import com.volcengine.tos.internal.model.CRC64Checksum;
import com.volcengine.tos.internal.model.RetryCountNotifier;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import com.volcengine.tos.internal.util.base64.Base64;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;
import org.jetbrains.annotations.NotNull;

public class TosRawTrailerInputStream
extends FilterInputStream
implements RetryCountNotifier,
Retryable {
    private long remaining;
    private final String trailerHeaderKey;
    private final Checksum checkSum;
    private String trailerHeaderContent;

    public TosRawTrailerInputStream(InputStream in, long remaining, String trailerHeaderKey) {
        super(in);
        this.remaining = remaining;
        this.trailerHeaderKey = trailerHeaderKey + ":";
        this.checkSum = new CRC64Checksum();
    }

    @Override
    public int read() throws IOException {
        int n = this.in.read();
        if (this.remaining > 0L) {
            --this.remaining;
            this.checkSum.update(n);
            return n;
        }
        this.extractTrailerHeader(new byte[]{(byte)n}, 0, 1);
        this.checkCrc64();
        return -1;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        int readOnce = this.in.read(b, off, len);
        if (readOnce == -1) {
            this.checkCrc64();
            return -1;
        }
        if (this.remaining > (long)readOnce) {
            this.remaining -= (long)readOnce;
            this.checkSum.update(b, off, readOnce);
            return readOnce;
        }
        int ret = (int)this.remaining;
        this.remaining = 0L;
        this.checkSum.update(b, off, ret);
        this.extractTrailerHeader(b, off + ret, readOnce - ret);
        return ret;
    }

    private void extractTrailerHeader(byte[] b, int off, int len) throws IOException {
        int readOnce;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (len > 0) {
            bos.write(b, off, len);
        }
        byte[] p = new byte[1024];
        while ((readOnce = this.in.read(p)) != -1) {
            bos.write(p, 0, readOnce);
        }
        this.trailerHeaderContent = bos.toString().trim();
    }

    private void checkCrc64() {
        String expect;
        if (StringUtils.isEmpty(this.trailerHeaderContent) || !this.trailerHeaderContent.startsWith(this.trailerHeaderKey)) {
            throw new TosClientException("try to check crc64 for getting object by trailer header failed", null);
        }
        String actual = this.trailerHeaderContent.substring(this.trailerHeaderKey.length()).trim();
        if (!actual.equals(expect = new String(Base64.encodeBase64(TosUtils.longToByteArray(this.checkSum.getValue()))))) {
            throw new TosClientException("check crc64 for getting object by trailer header failed, expect base64 crc64 " + expect + ", actual base64 crc64 " + actual, null);
        }
    }

    @Override
    public void setRetryCount(int retryCount) {
        if (this.in instanceof RetryCountNotifier) {
            ((RetryCountNotifier)((Object)this.in)).setRetryCount(retryCount);
        }
    }
}

