/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.volcengine.tos.internal.util.dnscache.DnsCacheService;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;

public class RequestDnsInterceptor
implements ExecChainHandler {
    private DnsCacheService dnsCacheService;

    RequestDnsInterceptor(DnsCacheService dnsCacheService) {
        this.dnsCacheService = dnsCacheService;
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        try {
            return chain.proceed(request, scope);
        }
        catch (IOException | HttpException e) {
            try {
                if (request != null && request.getUri() != null && request.getUri().getHost() != null) {
                    this.dnsCacheService.removeAddress(request.getUri().getHost());
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            throw e;
        }
    }

    public void setDnsCacheService(DnsCacheService dnsCacheService) {
        this.dnsCacheService = dnsCacheService;
    }
}

