/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import parquet.Log;
import parquet.filter.UnboundRecordFilter;
import parquet.hadoop.BadConfigurationException;
import parquet.hadoop.Footer;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetFileWriter;
import parquet.hadoop.ParquetInputSplit;
import parquet.hadoop.ParquetRecordReader;
import parquet.hadoop.api.InitContext;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.FileMetaData;
import parquet.hadoop.metadata.GlobalMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.hadoop.util.ConfigurationUtil;
import parquet.hadoop.util.ContextUtil;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class ParquetInputFormat<T>
extends FileInputFormat<Void, T> {
    private static final Log LOG = Log.getLog(ParquetInputFormat.class);
    public static final String READ_SUPPORT_CLASS = "parquet.read.support.class";
    public static final String UNBOUND_RECORD_FILTER = "parquet.read.filter";
    private Class<?> readSupportClass;
    private List<Footer> footers;
    private static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    public static void setReadSupportClass(Job job, Class<?> readSupportClass) {
        ContextUtil.getConfiguration((JobContext)job).set(READ_SUPPORT_CLASS, readSupportClass.getName());
    }

    public static void setUnboundRecordFilter(Job job, Class<? extends UnboundRecordFilter> filterClass) {
        ContextUtil.getConfiguration((JobContext)job).set(UNBOUND_RECORD_FILTER, filterClass.getName());
    }

    public static Class<?> getUnboundRecordFilter(Configuration configuration) {
        return ConfigurationUtil.getClassFromConfig(configuration, UNBOUND_RECORD_FILTER, UnboundRecordFilter.class);
    }

    public static void setReadSupportClass(JobConf conf, Class<?> readSupportClass) {
        conf.set(READ_SUPPORT_CLASS, readSupportClass.getName());
    }

    public static Class<?> getReadSupportClass(Configuration configuration) {
        return ConfigurationUtil.getClassFromConfig(configuration, READ_SUPPORT_CLASS, ReadSupport.class);
    }

    public ParquetInputFormat() {
    }

    public <S extends ReadSupport<T>> ParquetInputFormat(Class<S> readSupportClass) {
        this.readSupportClass = readSupportClass;
    }

    public RecordReader<Void, T> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        ReadSupport<T> readSupport = this.getReadSupport(ContextUtil.getConfiguration((JobContext)taskAttemptContext));
        Class<?> unboundRecordFilterClass = ParquetInputFormat.getUnboundRecordFilter(ContextUtil.getConfiguration((JobContext)taskAttemptContext));
        if (unboundRecordFilterClass == null) {
            return new ParquetRecordReader<T>(readSupport);
        }
        try {
            return new ParquetRecordReader<T>(readSupport, (UnboundRecordFilter)unboundRecordFilterClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new BadConfigurationException("could not instantiate unbound record filter class", e);
        }
        catch (IllegalAccessException e) {
            throw new BadConfigurationException("could not instantiate unbound record filter class", e);
        }
    }

    public ReadSupport<T> getReadSupport(Configuration configuration) {
        try {
            if (this.readSupportClass == null) {
                this.readSupportClass = ParquetInputFormat.getReadSupportClass(configuration);
            }
            return (ReadSupport)this.readSupportClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new BadConfigurationException("could not instantiate read support class", e);
        }
        catch (IllegalAccessException e) {
            throw new BadConfigurationException("could not instantiate read support class", e);
        }
    }

    static <T> List<ParquetInputSplit> generateSplits(List<BlockMetaData> blocks, BlockLocation[] hdfsBlocks, FileStatus fileStatus, FileMetaData fileMetaData, Class<?> readSupportClass, String requestedSchema, Map<String, String> readSupportMetadata) throws IOException {
        String fileSchema = fileMetaData.getSchema().toString().intern();
        Comparator<BlockLocation> comparator = new Comparator<BlockLocation>(){

            @Override
            public int compare(BlockLocation b1, BlockLocation b2) {
                return Long.signum(b1.getOffset() - b2.getOffset());
            }
        };
        Arrays.sort(hdfsBlocks, comparator);
        ArrayList splitGroups = new ArrayList(hdfsBlocks.length);
        for (int i = 0; i < hdfsBlocks.length; ++i) {
            splitGroups.add(new ArrayList());
        }
        for (BlockMetaData block : blocks) {
            final long firstDataPage = block.getColumns().get(0).getFirstDataPageOffset();
            int index = Arrays.binarySearch(hdfsBlocks, new BlockLocation(){

                public long getOffset() {
                    return firstDataPage;
                }
            }, comparator);
            if (index >= 0) {
                ((List)splitGroups.get(index)).add(block);
                continue;
            }
            int insertionPoint = -index - 1;
            if (insertionPoint == 0) {
                LOG.warn((Object)("row group before the first HDFS block:  " + block));
                ((List)splitGroups.get(0)).add(block);
                continue;
            }
            ((List)splitGroups.get(insertionPoint - 1)).add(block);
        }
        ArrayList<ParquetInputSplit> splits = new ArrayList<ParquetInputSplit>();
        for (int i = 0; i < hdfsBlocks.length; ++i) {
            BlockLocation hdfsBlock = hdfsBlocks[i];
            List blocksForCurrentSplit = (List)splitGroups.get(i);
            if (blocksForCurrentSplit.size() == 0) {
                LOG.debug((Object)("HDFS block without row group: " + hdfsBlocks[i]));
                continue;
            }
            long length = 0L;
            for (BlockMetaData block : blocksForCurrentSplit) {
                MessageType requested = MessageTypeParser.parseMessageType((String)requestedSchema);
                List<ColumnChunkMetaData> columns = block.getColumns();
                for (ColumnChunkMetaData column : columns) {
                    if (!requested.containsPath(column.getPath().toArray())) continue;
                    length += column.getTotalSize();
                }
            }
            splits.add(new ParquetInputSplit(fileStatus.getPath(), hdfsBlock.getOffset(), length, hdfsBlock.getHosts(), blocksForCurrentSplit, requestedSchema, fileSchema, fileMetaData.getKeyValueMetaData(), readSupportMetadata));
        }
        return splits;
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        splits.addAll(this.getSplits(ContextUtil.getConfiguration(jobContext), this.getFooters(jobContext)));
        return splits;
    }

    public List<ParquetInputSplit> getSplits(Configuration configuration, List<Footer> footers) throws IOException {
        ArrayList<ParquetInputSplit> splits = new ArrayList<ParquetInputSplit>();
        GlobalMetaData globalMetaData = ParquetFileWriter.getGlobalMetaData(footers);
        ReadSupport.ReadContext readContext = this.getReadSupport(configuration).init(new InitContext(configuration, globalMetaData.getKeyValueMetaData(), globalMetaData.getSchema()));
        for (Footer footer : footers) {
            Path file = footer.getFile();
            LOG.debug((Object)file);
            FileSystem fs = file.getFileSystem(configuration);
            FileStatus fileStatus = fs.getFileStatus(file);
            ParquetMetadata parquetMetaData = footer.getParquetMetadata();
            List<BlockMetaData> blocks = parquetMetaData.getBlocks();
            BlockLocation[] fileBlockLocations = fs.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen());
            splits.addAll(ParquetInputFormat.generateSplits(blocks, fileBlockLocations, fileStatus, parquetMetaData.getFileMetaData(), this.readSupportClass, readContext.getRequestedSchema().toString(), readContext.getReadSupportMetadata()));
        }
        return splits;
    }

    protected List<FileStatus> listStatus(JobContext jobContext) throws IOException {
        return ParquetInputFormat.getAllFileRecursively(super.listStatus(jobContext), ContextUtil.getConfiguration(jobContext));
    }

    private static List<FileStatus> getAllFileRecursively(List<FileStatus> files, Configuration conf) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        int len = files.size();
        for (int i = 0; i < len; ++i) {
            FileStatus file = files.get(i);
            if (file.isDir()) {
                Path p = file.getPath();
                FileSystem fs = p.getFileSystem(conf);
                ParquetInputFormat.staticAddInputPathRecursively(result, fs, p, hiddenFileFilter);
                continue;
            }
            result.add(file);
        }
        LOG.info((Object)("Total input paths to process : " + result.size()));
        return result;
    }

    private static void staticAddInputPathRecursively(List<FileStatus> result, FileSystem fs, Path path, PathFilter inputFilter) throws IOException {
        for (FileStatus stat : fs.listStatus(path, inputFilter)) {
            if (stat.isDir()) {
                ParquetInputFormat.staticAddInputPathRecursively(result, fs, stat.getPath(), inputFilter);
                continue;
            }
            result.add(stat);
        }
    }

    public List<Footer> getFooters(JobContext jobContext) throws IOException {
        if (this.footers == null) {
            this.footers = this.getFooters(ContextUtil.getConfiguration(jobContext), this.listStatus(jobContext));
        }
        return this.footers;
    }

    public List<Footer> getFooters(Configuration configuration, List<FileStatus> statuses) throws IOException {
        LOG.debug((Object)("reading " + statuses.size() + " files"));
        return ParquetFileReader.readAllFootersInParallelUsingSummaryFiles(configuration, statuses);
    }

    public GlobalMetaData getGlobalMetaData(JobContext jobContext) throws IOException {
        return ParquetFileWriter.getGlobalMetaData(this.getFooters(jobContext));
    }
}

