/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.io.ProtobufWritable;
import com.twitter.elephantbird.pig.util.AbstractWritableConverter;
import com.twitter.elephantbird.pig.util.PigToProtobuf;
import com.twitter.elephantbird.pig.util.PigUtil;
import com.twitter.elephantbird.pig.util.ProtobufToPig;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class ProtobufWritableConverter<M extends Message>
extends AbstractWritableConverter<ProtobufWritable<M>> {
    protected final TypeRef<M> typeRef;
    protected final ProtobufToPig protobufToPig;
    protected final Descriptors.Descriptor descriptor;
    protected final Schema expectedSchema;

    public ProtobufWritableConverter(String protobufClassName) {
        super(new ProtobufWritable());
        Preconditions.checkNotNull((Object)protobufClassName);
        this.typeRef = PigUtil.getProtobufTypeRef(protobufClassName);
        this.protobufToPig = new ProtobufToPig();
        ((ProtobufWritable)this.writable).setConverter(this.typeRef.getRawClass());
        this.descriptor = PigUtil.getProtobufDescriptor(this.typeRef.getRawClass());
        this.expectedSchema = this.protobufToPig.toSchema(this.descriptor);
    }

    @Override
    public void initialize(Class<? extends ProtobufWritable<M>> writableClass) throws IOException {
        if (writableClass == null) {
            return;
        }
        super.initialize(writableClass);
        ((ProtobufWritable)this.writable).setConverter(this.typeRef.getRawClass());
    }

    @Override
    public ResourceSchema.ResourceFieldSchema getLoadSchema() throws IOException {
        return new ResourceSchema.ResourceFieldSchema(new Schema.FieldSchema(null, this.protobufToPig.toSchema(Protobufs.getMessageDescriptor((Class)this.typeRef.getRawClass()))));
    }

    @Override
    public void checkStoreSchema(ResourceSchema.ResourceFieldSchema schema) throws IOException {
        Preconditions.checkNotNull((Object)schema, (Object)"Schema is null");
        Preconditions.checkArgument((110 == schema.getType() ? 1 : 0) != 0, (String)"Expected schema type '%s' but found type '%s'", (Object[])new Object[]{DataType.findTypeName((byte)110), DataType.findTypeName((byte)schema.getType())});
        ResourceSchema childSchema = schema.getSchema();
        Preconditions.checkNotNull((Object)childSchema, (Object)"Child schema is null");
        Schema actualSchema = Schema.getPigSchema((ResourceSchema)childSchema);
        Preconditions.checkArgument((boolean)Schema.equals((Schema)this.expectedSchema, (Schema)actualSchema, (boolean)false, (boolean)true), (String)"Expected store schema '%s' but found schema '%s'", (Object[])new Object[]{this.expectedSchema, actualSchema});
    }

    @Override
    public Object bytesToObject(DataByteArray dataByteArray) throws IOException {
        return this.bytesToTuple(dataByteArray.get(), null);
    }

    @Override
    protected Tuple toTuple(ProtobufWritable<M> writable, ResourceSchema.ResourceFieldSchema schema) throws IOException {
        return this.protobufToPig.toTuple((Message)writable.get());
    }

    @Override
    protected ProtobufWritable<M> toWritable(Tuple value) throws IOException {
        ((ProtobufWritable)this.writable).set(PigToProtobuf.tupleToMessage(this.typeRef.getRawClass(), value));
        return (ProtobufWritable)this.writable;
    }
}

