/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.twitter.elephantbird.pig.util.AbstractWritableConverter;
import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;

public class IntWritableConverter
extends AbstractWritableConverter<IntWritable> {
    public IntWritableConverter() {
        super(new IntWritable());
    }

    @Override
    public ResourceSchema.ResourceFieldSchema getLoadSchema() throws IOException {
        ResourceSchema.ResourceFieldSchema schema = new ResourceSchema.ResourceFieldSchema();
        schema.setType((byte)10);
        return schema;
    }

    @Override
    public Object bytesToObject(DataByteArray dataByteArray) throws IOException {
        return this.bytesToInteger(dataByteArray.get());
    }

    @Override
    protected String toCharArray(IntWritable writable) throws IOException {
        return String.valueOf(writable.get());
    }

    @Override
    protected Integer toInteger(IntWritable writable) throws IOException {
        return writable.get();
    }

    @Override
    protected Long toLong(IntWritable writable) throws IOException {
        return writable.get();
    }

    @Override
    protected Float toFloat(IntWritable writable) throws IOException {
        return Float.valueOf(writable.get());
    }

    @Override
    protected Double toDouble(IntWritable writable) throws IOException {
        return writable.get();
    }

    @Override
    public void checkStoreSchema(ResourceSchema.ResourceFieldSchema schema) throws IOException {
        switch (schema.getType()) {
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 55: {
                return;
            }
        }
        throw new IOException("Pig type '" + DataType.findTypeName((byte)schema.getType()) + "' unsupported");
    }

    @Override
    protected IntWritable toWritable(String value) throws IOException {
        return this.toWritable(Integer.parseInt(value));
    }

    @Override
    protected IntWritable toWritable(Integer value) throws IOException {
        ((IntWritable)this.writable).set(value.intValue());
        return (IntWritable)this.writable;
    }

    @Override
    protected IntWritable toWritable(Long value) throws IOException {
        return this.toWritable(value.intValue());
    }

    @Override
    protected IntWritable toWritable(Float value) throws IOException {
        return this.toWritable(value.intValue());
    }

    @Override
    protected IntWritable toWritable(Double value) throws IOException {
        return this.toWritable(value.intValue());
    }
}

