/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.store;

import com.google.common.base.Preconditions;
import com.twitter.elephantbird.pig.store.BaseStoreFunc;
import com.twitter.elephantbird.pig.util.SequenceFileConfig;
import com.twitter.elephantbird.pig.util.WritableConverter;
import com.twitter.elephantbird.util.HadoopCompat;
import java.io.IOException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.pig.LoadFunc;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.util.UDFContext;

public class SequenceFileStorage<K extends Writable, V extends Writable>
extends BaseStoreFunc {
    private final Config config;

    public SequenceFileStorage(String keyArgs, String valueArgs, String otherArgs) throws ParseException, IOException, ClassNotFoundException {
        this.config = new Config(keyArgs, valueArgs, otherArgs);
    }

    public SequenceFileStorage(String keyArgs, String valueArgs) throws ParseException, IOException, ClassNotFoundException {
        this.config = new Config(keyArgs, valueArgs, "");
    }

    public SequenceFileStorage() throws ParseException, IOException, ClassNotFoundException {
        this("", "", "");
    }

    public void checkSchema(ResourceSchema schema) throws IOException {
        Preconditions.checkNotNull((Object)schema, (Object)"Schema is null");
        ResourceSchema.ResourceFieldSchema[] fields = schema.getFields();
        Preconditions.checkNotNull((Object)fields, (Object)"Schema fields are undefined");
        Preconditions.checkArgument((2 == fields.length ? 1 : 0) != 0, (String)"Expecting 2 schema fields but found %s", (Object[])new Object[]{fields.length});
        this.config.keyConverter.checkStoreSchema(fields[0]);
        this.config.valueConverter.checkStoreSchema(fields[1]);
    }

    public String relToAbsPathForStoreLocation(String location, Path cwd) throws IOException {
        return LoadFunc.getAbsolutePath((String)location, (Path)cwd);
    }

    @Override
    public void setStoreLocation(String location, Job job) throws IOException {
        Configuration conf = HadoopCompat.getConfiguration((JobContext)job);
        this.ensureUDFContext(conf);
        SequenceFileStorage.verifyWritableClass(this.config.keyClass, true, this.config.keyConverter);
        SequenceFileStorage.verifyWritableClass(this.config.valueClass, false, this.config.valueConverter);
        job.setOutputKeyClass(this.config.keyClass);
        job.setOutputValueClass(this.config.valueClass);
        super.setStoreLocation(location, job);
        if ("true".equals(conf.get("output.compression.enabled"))) {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            String codec = conf.get("output.compression.codec");
            FileOutputFormat.setOutputCompressorClass((Job)job, PigContext.resolveClassName((String)codec).asSubclass(CompressionCodec.class));
        } else {
            this.setCompression(new Path(location), job);
        }
    }

    private void ensureUDFContext(Configuration conf) throws IOException {
        if (UDFContext.getUDFContext().isUDFConfEmpty() && conf.get("pig.udf.context") != null) {
            MapRedUtil.setupUDFContext((Configuration)conf);
        }
    }

    private static <W extends Writable> void verifyWritableClass(Class<W> writableClass, boolean isKeyClass, WritableConverter<W> writableConverter) {
        Preconditions.checkNotNull(writableClass, (String)"%s Writable class is undefined; WritableConverter of type '%s' does not define default Writable type, and no type was specified by user", (Object[])new Object[]{isKeyClass ? "Key" : "Value", writableConverter.getClass().getName()});
    }

    private void setCompression(Path path, Job job) {
        CompressionCodecFactory codecFactory = new CompressionCodecFactory(HadoopCompat.getConfiguration((JobContext)job));
        CompressionCodec codec = codecFactory.getCodec(path);
        if (codec != null) {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            FileOutputFormat.setOutputCompressorClass((Job)job, codec.getClass());
        } else {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)false);
        }
    }

    public OutputFormat<K, V> getOutputFormat() {
        return new SequenceFileOutputFormat();
    }

    public void putNext(Tuple t) throws IOException {
        if (t == null) {
            this.incrCounter(Error.NULL_TUPLE, 1L);
            return;
        }
        if (t.size() != 2) {
            this.incrCounter(Error.TUPLE_SIZE, 1L);
            return;
        }
        Object key = this.config.keyConverter.toWritable(t.get(0));
        if (key == null) {
            this.incrCounter(Error.NULL_KEY, 1L);
            return;
        }
        Object value = this.config.valueConverter.toWritable(t.get(1));
        if (value == null) {
            this.incrCounter(Error.NULL_VALUE, 1L);
            return;
        }
        this.writeRecord(key, value);
    }

    private class Config
    extends SequenceFileConfig<K, V> {
        public static final String TYPE_PARAM = "type";
        public Class<K> keyClass;
        public Class<V> valueClass;

        public Config(String keyArgs, String valueArgs, String otherArgs) throws ParseException, IOException {
            super(keyArgs, valueArgs, otherArgs);
        }

        @Override
        protected Options getKeyValueOptions() {
            OptionBuilder.withLongOpt((String)TYPE_PARAM);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"cls");
            OptionBuilder.withDescription((String)"Writable type of data. Defaults to type returned by getWritableClass() method of configured WritableConverter.");
            Option typeOption = OptionBuilder.create((String)"t");
            return super.getKeyValueOptions().addOption(typeOption);
        }

        @Override
        protected void initialize() throws IOException {
            this.keyClass = this.getWritableClass(this.keyArguments.getOptionValue(TYPE_PARAM));
            this.valueClass = this.getWritableClass(this.valueArguments.getOptionValue(TYPE_PARAM));
            this.keyConverter.initialize(this.keyClass);
            this.valueConverter.initialize(this.valueClass);
            if (this.keyClass == null) {
                this.keyClass = this.keyConverter.getWritableClass();
            }
            if (this.valueClass == null) {
                this.valueClass = this.valueConverter.getWritableClass();
            }
        }

        private <W extends Writable> Class<W> getWritableClass(String writableClassName) throws IOException {
            if (writableClassName == null) {
                return null;
            }
            try {
                return PigContext.resolveClassName((String)writableClassName);
            }
            catch (Exception e) {
                throw new IOException(String.format("Failed to load Writable class '%s'", writableClassName), e);
            }
        }
    }

    public static enum Error {
        NULL_TUPLE,
        TUPLE_SIZE,
        NULL_KEY,
        NULL_VALUE;

    }
}

