/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.store;

import com.twitter.elephantbird.mapreduce.input.LzoTextInputFormat;
import com.twitter.elephantbird.mapreduce.output.LzoOutputFormat;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.StorageUtil;

public class LzoPigStorage
extends PigStorage {
    private String delimiter = null;

    public LzoPigStorage() {
    }

    public LzoPigStorage(String delimiter) {
        super(delimiter);
        this.delimiter = delimiter;
    }

    public InputFormat<LongWritable, Text> getInputFormat() {
        return new LzoTextInputFormat();
    }

    public OutputFormat<NullWritable, Tuple> getOutputFormat() {
        return new TupleOutputFormat(this.delimiter);
    }

    protected static class TupleOutputFormat
    extends LzoOutputFormat<NullWritable, Tuple> {
        private byte fieldDel;

        public TupleOutputFormat(String delimiter) {
            this.fieldDel = (byte)(delimiter == null ? 9 : (int)StorageUtil.parseFieldDel((String)delimiter));
        }

        public RecordWriter<NullWritable, Tuple> getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
            final DataOutputStream out = this.getOutputStream(job);
            return new RecordWriter<NullWritable, Tuple>(){

                public void close(TaskAttemptContext context) throws IOException, InterruptedException {
                    out.close();
                }

                public void write(NullWritable key, Tuple value) throws IOException, InterruptedException {
                    int sz = value.size();
                    for (int i = 0; i < sz; ++i) {
                        StorageUtil.putField((OutputStream)out, (Object)value.get(i));
                        if (i == sz - 1) continue;
                        out.writeByte(TupleOutputFormat.this.fieldDel);
                    }
                    out.write(10);
                }
            };
        }
    }
}

