/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.cascading2.scheme;

import cascading.flow.FlowProcess;
import cascading.tap.Tap;
import com.twitter.elephantbird.cascading2.scheme.LzoBinaryScheme;
import com.twitter.elephantbird.mapred.output.DeprecatedOutputFormatWrapper;
import com.twitter.elephantbird.mapreduce.input.MultiInputFormat;
import com.twitter.elephantbird.mapreduce.input.combine.DelegateCombineFileInputFormat;
import com.twitter.elephantbird.mapreduce.io.ThriftWritable;
import com.twitter.elephantbird.mapreduce.output.LzoThriftBlockOutputFormat;
import com.twitter.elephantbird.util.ThriftUtils;
import com.twitter.elephantbird.util.TypeRef;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.thrift.TBase;

public class LzoThriftScheme<M extends TBase<?, ?>>
extends LzoBinaryScheme<M, ThriftWritable<M>> {
    private static final long serialVersionUID = -5011096855302946109L;
    private Class thriftClass;

    public LzoThriftScheme(Class thriftClass) {
        this.thriftClass = thriftClass;
    }

    public void sinkConfInit(FlowProcess<JobConf> hfp, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        LzoThriftBlockOutputFormat.setClassConf((Class)this.thriftClass, (Configuration)conf);
        DeprecatedOutputFormatWrapper.setOutputFormat(LzoThriftBlockOutputFormat.class, (JobConf)conf);
    }

    @Override
    protected ThriftWritable<M> prepareBinaryWritable() {
        TypeRef typeRef = ThriftUtils.getTypeRef((Class)this.thriftClass);
        return new ThriftWritable(typeRef);
    }

    public void sourceConfInit(FlowProcess<JobConf> hfp, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        MultiInputFormat.setClassConf((Class)this.thriftClass, (Configuration)conf);
        DelegateCombineFileInputFormat.setDelegateInputFormat((JobConf)conf, MultiInputFormat.class);
    }
}

