/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.cascading2.scheme;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LzoBinaryScheme<M, T extends BinaryWritable<M>>
extends Scheme<JobConf, RecordReader, OutputCollector, Object[], T> {
    private static final Logger LOG = LoggerFactory.getLogger(LzoBinaryScheme.class);
    private static final long serialVersionUID = -5011096855302946106L;

    public void sink(FlowProcess<JobConf> flowProcess, SinkCall<T, OutputCollector> sinkCall) throws IOException {
        OutputCollector collector = (OutputCollector)sinkCall.getOutput();
        TupleEntry entry = sinkCall.getOutgoingEntry();
        BinaryWritable writable = (BinaryWritable)sinkCall.getContext();
        writable.set(entry.getTuple().getObject(0));
        collector.collect(null, (Object)writable);
    }

    public void sinkPrepare(FlowProcess<JobConf> fp, SinkCall<T, OutputCollector> sinkCall) {
        sinkCall.setContext(this.prepareBinaryWritable());
    }

    protected abstract T prepareBinaryWritable();

    public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Object[] context = (Object[])sourceCall.getContext();
        while (((RecordReader)sourceCall.getInput()).next(context[0], context[1])) {
            Object out = ((BinaryWritable)context[1]).get();
            if (out != null) {
                sourceCall.getIncomingEntry().setTuple(new Tuple(new Object[]{out}));
                return true;
            }
            LOG.warn("failed to decode record");
        }
        return false;
    }

    public void sourceCleanup(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        sourceCall.setContext(null);
    }

    public void sourcePrepare(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        sourceCall.setContext((Object)new Object[2]);
        ((Object[])sourceCall.getContext())[0] = ((RecordReader)sourceCall.getInput()).createKey();
        ((Object[])sourceCall.getContext())[1] = ((RecordReader)sourceCall.getInput()).createValue();
    }
}

