/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.paranamer.mojo;

import com.thoughtworks.paranamer.generator.ParanamerGenerator;
import com.thoughtworks.paranamer.generator.QdoxParanamerGenerator;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ParanamerGeneratorMojo
extends AbstractMojo {
    public static final String skipProp = "skipParanamer";
    @Parameter(defaultValue="${project.build.sourceDirectory}", required=true)
    protected String sourceDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    protected String outputDirectory;
    private ParanamerGenerator generator = new QdoxParanamerGenerator();

    public boolean skip() {
        return System.getProperties().containsKey(skipProp);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip()) {
            this.getLog().info((CharSequence)"\n\tSkipping ParanamerGeneratorMojo as \"skipParanamer\" system property is set\n");
            return;
        }
        this.getLog().info((CharSequence)("Generating parameter names from " + this.sourceDirectory + " to " + this.outputDirectory));
        try {
            this.generator.processSourcePath(this.sourceDirectory, this.outputDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate parameter names from " + this.sourceDirectory, (Exception)e);
        }
    }
}

