/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.util.datastructures;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import com.thinkaurelius.titan.util.datastructures.ArraysUtil;
import com.thinkaurelius.titan.util.datastructures.IntSet;

public class IntHashSet
extends OpenIntIntHashMap
implements IntSet {
    private static final long serialVersionUID = -7297353805905443841L;
    private static final int defaultValue = 1;

    public IntHashSet() {
    }

    public IntHashSet(int size) {
        super(size);
    }

    @Override
    public boolean add(int value) {
        return super.put(value, 1);
    }

    @Override
    public boolean addAll(int[] values) {
        boolean addedAll = true;
        for (int i = 0; i < values.length; ++i) {
            if (this.add(values[i])) continue;
            addedAll = false;
        }
        return addedAll;
    }

    @Override
    public boolean contains(int value) {
        return super.containsKey(value);
    }

    @Override
    public boolean remove(int value) {
        return super.removeKey(value);
    }

    @Override
    public int[] getAll() {
        IntArrayList keys = new IntArrayList(this.size());
        this.keys(keys);
        assert (keys.size() == this.size()) : keys.size() + " vs " + this.size();
        int[] all = keys.elements();
        assert (all.length == this.size());
        return all;
    }

    @Override
    public int size() {
        return super.size();
    }

    public int hashCode() {
        return ArraysUtil.sum(this.getAll());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntSet)) {
            return false;
        }
        IntSet oth = (IntSet)other;
        for (int i = 0; i < this.values.length; ++i) {
            if (oth.contains(this.values[i])) continue;
            return false;
        }
        return this.size() == oth.size();
    }
}

