/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.util.datastructures;

import cern.colt.Arrays;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;

public class ArraysUtil {
    public static final boolean isSortedInc(long[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (i <= 0 || arr[i] > arr[i - 1]) continue;
            return false;
        }
        return true;
    }

    public static final boolean isSortedInc(int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (i <= 0 || arr[i] > arr[i - 1]) continue;
            return false;
        }
        return true;
    }

    public static final long[] insertSortedInc(long[] arr, long element) {
        assert (arr == null || ArraysUtil.isSortedInc(arr));
        long[] newarr = new long[arr != null ? arr.length + 1 : 1];
        int offset = 0;
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                Preconditions.checkArgument((element != arr[i] ? 1 : 0) != 0);
                if (element < arr[i]) {
                    newarr[i] = element;
                    offset = 1;
                }
                newarr[i + offset] = arr[i];
            }
        }
        if (offset == 0) {
            newarr[newarr.length - 1] = element;
        }
        return newarr;
    }

    public static final long[] arrayDifference(long[] arr, long[] subset) {
        long[] res = new long[arr.length - subset.length];
        int pos = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (Longs.contains((long[])subset, (long)arr[i])) continue;
            res[pos] = arr[i];
            ++pos;
        }
        assert (pos == res.length);
        return res;
    }

    public static final long[] mergeSortedInc(long[] a, long[] b) {
        assert (ArraysUtil.isSortedInc(a) && ArraysUtil.isSortedInc(b));
        long[] res = new long[a.length + b.length];
        int ai = 0;
        int bi = 0;
        while (ai < a.length || bi < b.length) {
            if (a[ai] < b[bi]) {
                res[ai + bi] = a[ai];
                ++ai;
                continue;
            }
            if (b[bi] < a[ai]) {
                res[ai + bi] = b[bi];
                ++bi;
                continue;
            }
            throw new IllegalArgumentException(Arrays.toString((long[])a) + "|" + Arrays.toString((long[])b));
        }
        return res;
    }

    public static final int sum(int[] values) {
        int sum = 0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static final int indexOfMin(double[] values) {
        if (values.length < 1) {
            return -1;
        }
        int index = 0;
        for (int i = 1; i < values.length; ++i) {
            if (!(values[i] < values[index])) continue;
            index = i;
        }
        return index;
    }

    public static final int indexOf(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }
}

