/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.vertices;

import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.InvalidElementException;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.TitanLabel;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.internal.AbstractElement;
import com.thinkaurelius.titan.graphdb.internal.ElementLifeCycle;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.query.QueryUtil;
import com.thinkaurelius.titan.graphdb.query.VertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.system.SystemKey;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.StringFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractVertex
extends AbstractElement
implements InternalVertex {
    private final StandardTitanTx tx;

    protected AbstractVertex(StandardTitanTx tx, long id) {
        super(id);
        assert (tx != null);
        this.tx = tx;
    }

    @Override
    public final InternalVertex it() {
        if (this.tx.isOpen()) {
            return this;
        }
        InternalVertex next = (InternalVertex)this.tx.getNextTx().getVertex(this.getID());
        if (next == null) {
            throw new InvalidElementException("Vertex has been removed", this);
        }
        return next;
    }

    @Override
    public final StandardTitanTx tx() {
        return this.tx.isOpen() ? this.tx : this.tx.getNextTx();
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    @Override
    public Object getId() {
        return this.getID();
    }

    @Override
    public boolean isModified() {
        return ElementLifeCycle.isModified(this.it().getLifeCycle());
    }

    @Override
    public synchronized void remove() {
        if (this.it().isRemoved()) {
            return;
        }
        Iterator<TitanRelation> iter = this.it().getRelations().iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        for (TitanRelation r : QueryUtil.queryAll(this.it())) {
            if (r.getType().equals(SystemKey.VertexState)) {
                r.remove();
                continue;
            }
            throw new IllegalStateException("Cannot remove vertex since it is still connected");
        }
    }

    @Override
    public VertexCentricQueryBuilder query() {
        return this.tx().query(this.it());
    }

    public Set<String> getPropertyKeys() {
        HashSet<String> result = new HashSet<String>();
        for (TitanProperty p : this.getProperties()) {
            result.add(p.getPropertyKey().getName());
        }
        return result;
    }

    @Override
    public <O> O getProperty(TitanKey key) {
        Iterator<TitanProperty> iter = this.query().type(key).includeHidden().properties().iterator();
        if (key.isUnique(Direction.OUT)) {
            if (iter.hasNext()) {
                return (O)iter.next().getValue();
            }
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        while (iter.hasNext()) {
            result.add(iter.next().getValue());
        }
        return (O)result;
    }

    @Override
    public <O> O getProperty(String key) {
        if (!this.tx().containsType(key)) {
            return null;
        }
        return this.getProperty(this.tx().getPropertyKey(key));
    }

    @Override
    public Iterable<TitanProperty> getProperties() {
        return this.query().properties();
    }

    @Override
    public Iterable<TitanProperty> getProperties(TitanKey key) {
        return this.query().type(key).properties();
    }

    @Override
    public Iterable<TitanProperty> getProperties(String key) {
        return this.query().keys(key).properties();
    }

    @Override
    public Iterable<TitanEdge> getEdges() {
        return this.query().titanEdges();
    }

    @Override
    public Iterable<TitanEdge> getTitanEdges(Direction dir, TitanLabel ... labels) {
        return this.query().direction(dir).types(labels).titanEdges();
    }

    @Override
    public Iterable<Edge> getEdges(Direction dir, String ... labels) {
        return this.query().direction(dir).labels(labels).edges();
    }

    @Override
    public Iterable<TitanRelation> getRelations() {
        return this.query().relations();
    }

    public Iterable<Vertex> getVertices(Direction direction, String ... labels) {
        return this.query().direction(direction).labels(labels).vertices();
    }

    @Override
    public long getPropertyCount() {
        return this.query().propertyCount();
    }

    @Override
    public long getEdgeCount() {
        return this.query().count();
    }

    @Override
    public boolean isConnected() {
        return !Iterables.isEmpty(this.getEdges());
    }

    @Override
    public TitanProperty addProperty(TitanKey key, Object attribute) {
        return this.tx().addProperty((TitanVertex)this.it(), key, attribute);
    }

    @Override
    public TitanProperty addProperty(String key, Object attribute) {
        return this.tx().addProperty((TitanVertex)this.it(), key, attribute);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.setProperty(this.tx().getPropertyKey(key), value);
    }

    @Override
    public void setProperty(TitanKey key, Object value) {
        this.tx().setProperty(this.it(), key, value);
    }

    @Override
    public TitanEdge addEdge(TitanLabel label, TitanVertex vertex) {
        return this.tx().addEdge((TitanVertex)this.it(), vertex, label);
    }

    @Override
    public TitanEdge addEdge(String label, TitanVertex vertex) {
        return this.tx().addEdge((TitanVertex)this.it(), vertex, label);
    }

    public Edge addEdge(String label, Vertex vertex) {
        return this.addEdge(label, (TitanVertex)vertex);
    }

    @Override
    public <O> O removeProperty(TitanType key) {
        assert (key.isPropertyKey());
        Object result = null;
        for (TitanProperty p : this.query().type(key).properties()) {
            result = p.getValue();
            p.remove();
        }
        return (O)result;
    }

    @Override
    public <O> O removeProperty(String key) {
        if (!this.tx().containsType(key)) {
            return null;
        }
        return this.removeProperty(this.tx().getPropertyKey(key));
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        try {
            return this.id == ((AbstractVertex)other).id;
        }
        catch (ClassCastException e) {
            return super.equals(other);
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

