/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.util;

import com.google.common.base.Preconditions;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class VertexCentricEdgeIterable
implements Iterable<Edge> {
    private final Iterable<Vertex> vertices;

    public VertexCentricEdgeIterable(Iterable<Vertex> vertices) {
        Preconditions.checkNotNull(vertices);
        this.vertices = vertices;
    }

    @Override
    public Iterator<Edge> iterator() {
        return new EdgeIterator(this.vertices.iterator());
    }

    private static class EdgeIterator
    implements Iterator<Edge> {
        private final Iterator<Vertex> vertexIter;
        private Iterator<Edge> currentOutEdges;
        private Edge nextEdge = null;

        public EdgeIterator(Iterator<Vertex> vertexIter) {
            this.vertexIter = vertexIter;
            if (vertexIter.hasNext()) {
                this.currentOutEdges = vertexIter.next().getEdges(Direction.OUT, new String[0]).iterator();
                this.getNextEdge();
            }
        }

        private void getNextEdge() {
            assert (this.vertexIter != null && this.currentOutEdges != null);
            this.nextEdge = null;
            while (this.nextEdge == null) {
                if (this.currentOutEdges.hasNext()) {
                    this.nextEdge = this.currentOutEdges.next();
                    break;
                }
                if (!this.vertexIter.hasNext()) break;
                this.currentOutEdges = this.vertexIter.next().getEdges(Direction.OUT, new String[0]).iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextEdge != null;
        }

        @Override
        public Edge next() {
            if (this.nextEdge == null) {
                throw new NoSuchElementException();
            }
            Edge returnEdge = this.nextEdge;
            this.getNextEdge();
            return returnEdge;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

