/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types.vertices;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.graphdb.internal.InternalType;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.TypeAttribute;
import com.thinkaurelius.titan.graphdb.types.TypeAttributeType;
import com.thinkaurelius.titan.graphdb.types.system.SystemKey;
import com.thinkaurelius.titan.graphdb.vertices.CacheVertex;
import com.tinkerpop.blueprints.Direction;

public abstract class TitanTypeVertex
extends CacheVertex
implements InternalType {
    private String name = null;
    private TypeAttribute.Map definition = null;

    public TitanTypeVertex(StandardTitanTx tx, long id, byte lifecycle) {
        super(tx, id, lifecycle);
    }

    @Override
    public String getName() {
        if (this.name == null) {
            TitanProperty p = (TitanProperty)Iterables.getOnlyElement(this.query().includeHidden().type(SystemKey.TypeName).properties(), null);
            Preconditions.checkState((p != null ? 1 : 0) != 0, (String)"Could not find type for id: %s", (Object[])new Object[]{this.getID()});
            this.name = p.getValue(String.class);
        }
        assert (this.name != null);
        return this.name;
    }

    protected TypeAttribute.Map getDefinition() {
        if (this.definition == null) {
            TypeAttribute.Map def = new TypeAttribute.Map();
            for (TitanProperty p : this.query().includeHidden().type(SystemKey.TypeDefinition).properties()) {
                def.add(p.getValue(TypeAttribute.class));
            }
            this.definition = def;
        }
        return this.definition;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isUnique(Direction direction) {
        return this.getDefinition().getValue(TypeAttributeType.UNIQUENESS, boolean[].class)[EdgeDirection.position(direction)];
    }

    @Override
    public boolean uniqueLock(Direction direction) {
        return this.isUnique(direction) && this.getDefinition().getValue(TypeAttributeType.UNIQUENESS_LOCK, boolean[].class)[EdgeDirection.position(direction)];
    }

    @Override
    public boolean isStatic(Direction direction) {
        return this.getDefinition().getValue(TypeAttributeType.STATIC, boolean[].class)[EdgeDirection.position(direction)];
    }

    @Override
    public long[] getSortKey() {
        return this.getDefinition().getValue(TypeAttributeType.SORT_KEY, long[].class);
    }

    @Override
    public Order getSortOrder() {
        return this.getDefinition().getValue(TypeAttributeType.SORT_ORDER, Order.class);
    }

    @Override
    public long[] getSignature() {
        return this.getDefinition().getValue(TypeAttributeType.SIGNATURE, long[].class);
    }

    @Override
    public boolean isModifiable() {
        return this.getDefinition().getValue(TypeAttributeType.MODIFIABLE, Boolean.TYPE);
    }

    @Override
    public boolean isHidden() {
        return this.getDefinition().getValue(TypeAttributeType.HIDDEN, Boolean.TYPE);
    }
}

