/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types.system;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.thinkaurelius.titan.graphdb.types.system.SystemKey;
import com.thinkaurelius.titan.graphdb.types.system.SystemType;
import java.util.Map;
import java.util.Set;

public abstract class SystemTypeManager {
    public static final String systemETprefix = "#System#";
    public static final int SYSTEM_TYPE_OFFSET = 8;
    private static volatile Map<Long, SystemType> SYSTEM_EDGE_TYPES;
    public static final Set<? extends SystemType> prepersistedSystemTypes;

    public static boolean isSystemRelationType(long id) {
        return SYSTEM_EDGE_TYPES.containsKey(id);
    }

    public static SystemType getSystemRelationType(long id) {
        SystemType type = SYSTEM_EDGE_TYPES.get(id);
        if (type == null) {
            throw new IllegalArgumentException("System edge type is unknown with ID:" + id);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<SystemTypeManager> clazz = SystemTypeManager.class;
        synchronized (SystemTypeManager.class) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (SystemType systemType : SystemKey.KEY_MAP.values()) {
                builder.put((Object)systemType.getID(), (Object)systemType);
            }
            SYSTEM_EDGE_TYPES = builder.build();
            // ** MonitorExit[clazz] (shouldn't be in output)
            prepersistedSystemTypes = ImmutableSet.of((Object)SystemKey.TypeName, (Object)SystemKey.TypeDefinition, (Object)SystemKey.TypeClass);
            return;
        }
    }
}

