/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types.system;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.graphdb.internal.RelationType;
import com.thinkaurelius.titan.graphdb.types.TitanTypeClass;
import com.thinkaurelius.titan.graphdb.types.TypeAttribute;
import com.thinkaurelius.titan.graphdb.types.system.SystemType;
import com.thinkaurelius.titan.util.datastructures.IterablesUtil;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.util.Map;

public class SystemKey
extends SystemType
implements TitanKey {
    public static final SystemKey TypeName = new SystemKey("TypeName", String.class, 1, true, new boolean[]{true, true}, false);
    public static final SystemKey TypeDefinition = new SystemKey("TypeDefinition", TypeAttribute.class, 2, false, new boolean[]{false, false}, false);
    public static final SystemKey TypeClass = new SystemKey("TypeClass", TitanTypeClass.class, 3, true, new boolean[]{true, false}, false);
    public static final SystemKey VertexState = new SystemKey("VertexState", Byte.class, 4, false, new boolean[]{true, false}, true);
    public static final Map<String, SystemKey> KEY_MAP = ImmutableMap.of((Object)TypeDefinition.getName(), (Object)TypeDefinition, (Object)TypeName.getName(), (Object)TypeName, (Object)TypeClass.getName(), (Object)TypeClass, (Object)VertexState.getName(), (Object)VertexState);
    private final Class<?> dataType;
    private final boolean index;

    private SystemKey(String name, Class<?> dataType, int id) {
        this(name, dataType, id, false, new boolean[]{true, false}, false);
    }

    private SystemKey(String name, Class<?> dataType, int id, boolean index, boolean[] uniqueness, boolean modifiable) {
        super(name, id, RelationType.PROPERTY, uniqueness, new boolean[]{!modifiable, uniqueness[1] && index}, modifiable);
        this.dataType = dataType;
        this.index = index;
    }

    @Override
    public Class<?> getDataType() {
        return this.dataType;
    }

    @Override
    public Iterable<String> getIndexes(Class<? extends Element> elementType) {
        if (this.index && elementType == Vertex.class) {
            return ImmutableList.of((Object)"standard");
        }
        return IterablesUtil.emptyIterable();
    }

    @Override
    public boolean hasIndex(String name, Class<? extends Element> elementType) {
        return elementType == Vertex.class && this.index && "standard".equals(name);
    }

    @Override
    public final boolean isPropertyKey() {
        return true;
    }

    @Override
    public final boolean isEdgeLabel() {
        return false;
    }

    public static enum VertexStates {
        DEFAULT(0);

        private byte value;

        private VertexStates(int value) {
            Preconditions.checkArgument((value >= 0 && value <= 127 ? 1 : 0) != 0);
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

