/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.graphdb.types.TypeAttributeType;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class TypeAttribute {
    private TypeAttributeType type;
    private Object value;

    public TypeAttribute() {
    }

    public TypeAttribute(TypeAttributeType type, Object value) {
        assert (type != null);
        assert (value != null);
        this.type = type;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public TypeAttributeType getType() {
        return this.type;
    }

    public static void isValidKeyDefinition(Map definition) {
        TypeAttribute.isValidDefinition(definition, TypeAttributeType.PROPERTY_KEY_TYPES);
    }

    public static void isValidLabelDefinition(Map definition) {
        TypeAttribute.isValidDefinition(definition, TypeAttributeType.EDGE_LABEL_TYPES);
    }

    private static void isValidDefinition(Map definition, Set<TypeAttributeType> types) {
        assert (definition != null);
        Set keys = definition.keySet();
        for (TypeAttributeType type : types) {
            assert (keys.contains((Object)type));
        }
        assert (keys.size() == types.size());
    }

    public static class Map
    extends EnumMap<TypeAttributeType, Object> {
        public Map() {
            super(TypeAttributeType.class);
        }

        public void add(TypeAttribute attribute) {
            this.setValue(attribute.getType(), attribute.getValue());
        }

        public Map setValue(TypeAttributeType type, Object value) {
            assert (type != null);
            assert (value != null);
            assert (type.verifyAttribute(value));
            super.put(type, value);
            return this;
        }

        public <O> O getValue(TypeAttributeType type) {
            assert (type != null);
            Object value = super.get((Object)type);
            return (O)(value == null ? type.defaultValue(this) : value);
        }

        public <O> O getValue(TypeAttributeType type, Class<O> clazz) {
            assert (type != null);
            Object value = super.get((Object)type);
            return (O)(value == null ? type.defaultValue(this) : value);
        }

        public Iterable<TypeAttribute> getAttributes() {
            return Iterables.transform(super.entrySet(), (Function)new Function<Map.Entry<TypeAttributeType, Object>, TypeAttribute>(){

                @Nullable
                public TypeAttribute apply(@Nullable Map.Entry<TypeAttributeType, Object> entry) {
                    return new TypeAttribute(entry.getKey(), entry.getValue());
                }
            });
        }
    }
}

