/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.LabelMaker;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.TitanLabel;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.core.TypeMaker;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.StandardTypeMaker;
import com.thinkaurelius.titan.graphdb.types.TypeAttribute;
import com.thinkaurelius.titan.graphdb.types.TypeAttributeType;
import com.tinkerpop.blueprints.Direction;

public class StandardLabelMaker
extends StandardTypeMaker
implements LabelMaker {
    private boolean isUnidirectional = false;

    public StandardLabelMaker(StandardTitanTx tx, IndexSerializer indexSerializer) {
        super(tx, indexSerializer);
    }

    @Override
    public StandardLabelMaker directed() {
        this.isUnidirectional = false;
        return this;
    }

    @Override
    public StandardLabelMaker unidirected() {
        this.isUnidirectional = true;
        return this;
    }

    @Override
    public LabelMaker oneToMany(TypeMaker.UniquenessConsistency consistency) {
        super.unique(Direction.IN, consistency);
        return this;
    }

    @Override
    public LabelMaker oneToMany() {
        return this.oneToMany(TypeMaker.UniquenessConsistency.LOCK);
    }

    @Override
    public LabelMaker manyToOne(TypeMaker.UniquenessConsistency consistency) {
        super.unique(Direction.OUT, consistency);
        return this;
    }

    @Override
    public LabelMaker manyToOne() {
        return this.manyToOne(TypeMaker.UniquenessConsistency.LOCK);
    }

    @Override
    public LabelMaker oneToOne(TypeMaker.UniquenessConsistency consistency) {
        super.unique(Direction.BOTH, consistency);
        return this;
    }

    @Override
    public LabelMaker oneToOne() {
        return this.oneToOne(TypeMaker.UniquenessConsistency.LOCK);
    }

    @Override
    public LabelMaker manyToMany() {
        super.unique(Direction.BOTH, null);
        return this;
    }

    @Override
    public StandardLabelMaker signature(TitanType ... types) {
        super.signature(types);
        return this;
    }

    @Override
    public StandardLabelMaker sortKey(TitanType ... types) {
        super.sortKey(types);
        return this;
    }

    @Override
    public StandardLabelMaker sortOrder(Order order) {
        super.sortOrder(order);
        return this;
    }

    @Override
    public StandardLabelMaker hidden() {
        super.hidden();
        return this;
    }

    @Override
    public StandardLabelMaker unModifiable() {
        super.unModifiable();
        return this;
    }

    @Override
    public StandardLabelMaker makeStatic(Direction direction) {
        super.makeStatic(direction);
        return this;
    }

    @Override
    public TitanLabel make() {
        Preconditions.checkArgument((!this.isUnidirectional || !this.isUnique(Direction.IN) && !this.isStatic(Direction.IN) ? 1 : 0) != 0, (Object)"Unidirectional labels cannot be unique or static");
        TypeAttribute.Map definition = this.makeDefinition();
        definition.setValue(TypeAttributeType.UNIDIRECTIONAL, this.isUnidirectional);
        return this.tx.makeEdgeLabel(this.getName(), definition);
    }
}

