/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.Parameter;
import com.thinkaurelius.titan.graphdb.types.IndexParameters;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class IndexDefinition {
    private final String indexName;
    private final Class<? extends Element> element;
    private final Parameter[] parameters;

    public IndexDefinition(String indexName, Class<? extends Element> element, Parameter ... parameters) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)indexName));
        Preconditions.checkNotNull(element);
        Preconditions.checkArgument((Vertex.class.isAssignableFrom(element) || Edge.class.isAssignableFrom(element) ? 1 : 0) != 0, (String)"Element must be vertex or edge: %s", (Object[])new Object[]{element});
        Preconditions.checkNotNull((Object)parameters);
        this.indexName = indexName;
        this.element = element;
        this.parameters = parameters;
    }

    public static final IndexDefinition of(String indexName, Class<? extends Element> element, Parameter ... paras) {
        return new IndexDefinition(indexName, element, paras);
    }

    public static final IndexDefinition of(Class<? extends Element> element) {
        return new IndexDefinition("standard", element, new Parameter[0]);
    }

    public static final IndexDefinition of(IndexType type, IndexParameters paras) {
        Preconditions.checkArgument((boolean)type.getIndexName().equals(paras.getIndexName()));
        return new IndexDefinition(type.getIndexName(), type.getElementType(), paras.getParameters());
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Class<? extends Element> getElementType() {
        return this.element;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public boolean isStandardIndex() {
        return this.indexName.equals("standard");
    }

    public IndexType getIndexType() {
        return new IndexType(this.indexName, this.element);
    }

    public IndexParameters getIndexParamters() {
        return new IndexParameters(this.indexName, this.parameters);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        IndexDefinition oth = (IndexDefinition)other;
        return this.element.equals(oth.element) && this.indexName.equals(oth.indexName) && Arrays.deepEquals(this.parameters, oth.parameters);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.indexName).append(this.element).append((Object[])this.parameters).toHashCode();
    }

    public String toString() {
        return this.indexName + ":" + this.element.getSimpleName() + "(" + Arrays.deepToString(this.parameters) + ")";
    }
}

