/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.relations;

import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.relations.StandardRelation;
import com.thinkaurelius.titan.graphdb.vertices.AbstractVertex;
import com.thinkaurelius.titan.util.encoding.LongEncoding;
import com.tinkerpop.blueprints.Direction;
import java.util.Arrays;

public final class RelationIdentifier {
    public static final String TOSTRING_DELIMITER = "-";
    private final long outVertexId;
    private final long typeId;
    private final long relationId;

    private RelationIdentifier(long outVertexId, long typeId, long relationId) {
        this.outVertexId = outVertexId;
        this.typeId = typeId;
        this.relationId = relationId;
    }

    static final RelationIdentifier get(InternalRelation r) {
        if (r.hasId()) {
            return new RelationIdentifier(r.getVertex(0).getID(), r.getType().getID(), r.getID());
        }
        return null;
    }

    static final RelationIdentifier get(TitanProperty property) {
        if (property.hasId()) {
            return new RelationIdentifier(property.getVertex().getID(), property.getPropertyKey().getID(), property.getID());
        }
        return null;
    }

    static final RelationIdentifier get(TitanVertex startVertex, TitanType type, long relationId) {
        if (AbstractVertex.isTemporaryId(relationId)) {
            return null;
        }
        return new RelationIdentifier(startVertex.getID(), type.getID(), relationId);
    }

    static final RelationIdentifier get(TitanEdge edge) {
        if (edge.hasId()) {
            return new RelationIdentifier(edge.getVertex(Direction.OUT).getID(), edge.getTitanLabel().getID(), edge.getID());
        }
        return null;
    }

    public long[] getLongRepresentation() {
        long[] r = new long[]{this.outVertexId, this.typeId, this.relationId};
        return r;
    }

    public int hashCode() {
        return Long.valueOf(this.relationId).hashCode() + Long.valueOf(this.outVertexId).hashCode() * 743 + Long.valueOf(this.typeId).hashCode() * 3011;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        RelationIdentifier oth = (RelationIdentifier)other;
        return this.relationId == oth.relationId && this.outVertexId == oth.outVertexId && this.typeId == oth.typeId;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(LongEncoding.encode(this.relationId)).append(TOSTRING_DELIMITER).append(LongEncoding.encode(this.outVertexId)).append(TOSTRING_DELIMITER).append(LongEncoding.encode(this.typeId));
        return s.toString();
    }

    TitanRelation findRelation(TitanTransaction tx) {
        TitanVertex v = tx.getVertex(this.outVertexId);
        if (v == null) {
            return null;
        }
        TitanVertex type = tx.getVertex(this.typeId);
        if (type == null) {
            return null;
        }
        if (!(type instanceof TitanType)) {
            throw new IllegalArgumentException("Invalid RelationIdentifier: typeID does not reference a type");
        }
        for (TitanRelation r : v.query().types((TitanType)type).direction(Direction.OUT).relations()) {
            if (r.getID() != this.relationId && (!(r instanceof StandardRelation) || ((StandardRelation)((Object)r)).getPreviousID() != this.relationId)) continue;
            return r;
        }
        return null;
    }

    public TitanEdge findEdge(TitanTransaction tx) {
        TitanRelation r = this.findRelation(tx);
        if (r == null) {
            return null;
        }
        if (r instanceof TitanEdge) {
            return (TitanEdge)r;
        }
        throw new UnsupportedOperationException("Referenced relation is a property not an edge");
    }

    public TitanProperty findProperty(TitanTransaction tx) {
        TitanRelation r = this.findRelation(tx);
        if (r == null) {
            return null;
        }
        if (r instanceof TitanProperty) {
            return (TitanProperty)r;
        }
        throw new UnsupportedOperationException("Referenced relation is a edge not a property");
    }

    public static final RelationIdentifier parse(String id) {
        String[] elements = id.split(TOSTRING_DELIMITER);
        if (elements.length != 3) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + id);
        }
        try {
            return new RelationIdentifier(LongEncoding.decode(elements[1]), LongEncoding.decode(elements[2]), LongEncoding.decode(elements[0]));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid id - each token expected to be a number", e);
        }
    }

    public static final RelationIdentifier get(long[] ids) {
        if (ids.length != 3) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        for (int i = 0; i < 3; ++i) {
            if (ids[i] >= 0L) continue;
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        return new RelationIdentifier(ids[0], ids[1], ids[2]);
    }

    public static final RelationIdentifier get(int[] ids) {
        if (ids.length != 3) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        for (int i = 0; i < 3; ++i) {
            if (ids[i] >= 0) continue;
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        return new RelationIdentifier(ids[0], ids[1], ids[2]);
    }
}

