/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query;

import cern.colt.list.AbstractLongList;
import cern.colt.list.LongArrayList;
import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.graphdb.query.VertexArrayList;
import com.thinkaurelius.titan.graphdb.query.VertexListInternal;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import java.util.Iterator;

public class VertexLongList
implements VertexListInternal {
    private final StandardTitanTx tx;
    private final AbstractLongList vertices;
    private boolean sorted;

    public VertexLongList(StandardTitanTx tx) {
        this(tx, (AbstractLongList)new LongArrayList(), false);
    }

    public VertexLongList(StandardTitanTx tx, AbstractLongList vertices) {
        this(tx, vertices, false);
    }

    private VertexLongList(StandardTitanTx tx, AbstractLongList vertices, boolean sorted) {
        this.tx = tx;
        this.vertices = vertices;
        this.sorted = sorted;
    }

    @Override
    public void add(TitanVertex n) {
        if (this.sorted) {
            Preconditions.checkArgument((n.getID() >= this.vertices.get(this.vertices.size() - 1) ? 1 : 0) != 0, (Object)"Vertices must be inserted in sorted order");
        }
        this.vertices.add(n.getID());
    }

    @Override
    public long getID(int pos) {
        return this.vertices.get(pos);
    }

    @Override
    public AbstractLongList getIDs() {
        return this.vertices;
    }

    @Override
    public TitanVertex get(int pos) {
        return this.tx.getExistingVertex(this.getID(pos));
    }

    @Override
    public void sort() {
        if (this.sorted) {
            return;
        }
        this.vertices.sort();
        this.sorted = true;
    }

    @Override
    public int size() {
        return this.vertices.size();
    }

    @Override
    public void addAll(VertexList vertexlist) {
        AbstractLongList othervertexids = null;
        if (vertexlist instanceof VertexLongList) {
            othervertexids = ((VertexLongList)vertexlist).vertices;
        } else if (vertexlist instanceof VertexArrayList) {
            VertexArrayList other = (VertexArrayList)vertexlist;
            othervertexids = new LongArrayList(other.size());
            for (int i = 0; i < other.size(); ++i) {
                othervertexids.add(other.getID(i));
            }
        } else {
            throw new IllegalArgumentException("Unsupported vertex-list: " + vertexlist.getClass());
        }
        this.sorted = false;
        this.vertices.addAllOfFromTo(othervertexids, 0, othervertexids.size() - 1);
    }

    @Override
    public Iterator<TitanVertex> iterator() {
        return new Iterator<TitanVertex>(){
            private int pos = -1;

            @Override
            public boolean hasNext() {
                return this.pos + 1 < VertexLongList.this.size();
            }

            @Override
            public TitanVertex next() {
                ++this.pos;
                return VertexLongList.this.get(this.pos);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Vertices cannot be removed from neighborhood list");
            }
        };
    }
}

