/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.TitanLabel;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexQuery;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.internal.InternalType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.RelationType;
import com.thinkaurelius.titan.graphdb.query.AbstractVertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.query.BaseVertexCentricQuery;
import com.thinkaurelius.titan.graphdb.query.QueryProcessor;
import com.thinkaurelius.titan.graphdb.query.SimpleVertexQueryProcessor;
import com.thinkaurelius.titan.graphdb.query.VertexCentricQuery;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.DirectionCondition;
import com.thinkaurelius.titan.graphdb.query.condition.IncidenceCondition;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Query;
import com.tinkerpop.blueprints.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexCentricQueryBuilder
extends AbstractVertexCentricQueryBuilder
implements TitanVertexQuery {
    private static final Logger log = LoggerFactory.getLogger(VertexCentricQueryBuilder.class);
    private final InternalVertex vertex;
    private TitanVertex adjacentVertex = null;

    public VertexCentricQueryBuilder(InternalVertex v, EdgeSerializer serializer) {
        super(v.tx(), serializer);
        Preconditions.checkNotNull((Object)v);
        this.vertex = v;
    }

    @Override
    public TitanVertexQuery adjacentVertex(TitanVertex vertex) {
        Preconditions.checkNotNull((Object)vertex);
        this.adjacentVertex = vertex;
        return this;
    }

    @Override
    public VertexCentricQueryBuilder has(TitanKey key, Object value) {
        super.has(key, value);
        return this;
    }

    @Override
    public VertexCentricQueryBuilder has(TitanLabel label, TitanVertex vertex) {
        super.has(label, vertex);
        return this;
    }

    @Override
    public VertexCentricQueryBuilder has(String type, Object value) {
        super.has(type, value);
        return this;
    }

    @Override
    public VertexCentricQueryBuilder hasNot(String key, Object value) {
        super.hasNot(key, value);
        return this;
    }

    @Override
    public VertexCentricQueryBuilder has(String key, Predicate predicate, Object value) {
        super.has(key, predicate, value);
        return this;
    }

    @Override
    public VertexCentricQueryBuilder has(TitanKey key, Predicate predicate, Object value) {
        super.has(key, predicate, value);
        return this;
    }

    @Override
    public VertexCentricQueryBuilder has(String key) {
        super.has(key);
        return this;
    }

    @Override
    public VertexCentricQueryBuilder hasNot(String key) {
        super.hasNot(key);
        return this;
    }

    @Override
    public <T extends Comparable<?>> VertexCentricQueryBuilder interval(TitanKey key, T start, T end) {
        super.interval(key, (Comparable)start, (Comparable)end);
        return this;
    }

    @Override
    public <T extends Comparable<?>> VertexCentricQueryBuilder interval(String key, T start, T end) {
        super.interval(key, (Comparable)start, (Comparable)end);
        return this;
    }

    @Override
    @Deprecated
    public <T extends Comparable<T>> VertexCentricQueryBuilder has(String key, T value, Query.Compare compare) {
        super.has(key, value, compare);
        return this;
    }

    @Override
    public VertexCentricQueryBuilder types(TitanType ... types) {
        super.types(types);
        return this;
    }

    @Override
    public VertexCentricQueryBuilder labels(String ... labels) {
        super.labels(labels);
        return this;
    }

    @Override
    public VertexCentricQueryBuilder keys(String ... keys) {
        super.keys(keys);
        return this;
    }

    @Override
    public VertexCentricQueryBuilder type(TitanType type) {
        super.type(type);
        return this;
    }

    @Override
    public VertexCentricQueryBuilder direction(Direction d) {
        super.direction(d);
        return this;
    }

    @Override
    public VertexCentricQueryBuilder includeHidden() {
        super.includeHidden();
        return this;
    }

    @Override
    public VertexCentricQueryBuilder limit(int limit) {
        super.limit(limit);
        return this;
    }

    @Override
    protected EdgeSerializer.VertexConstraint getVertexConstraint() {
        if (this.adjacentVertex != null && this.vertex.hasId() && this.adjacentVertex.hasId()) {
            return new EdgeSerializer.VertexConstraint(this.vertex.getID(), this.adjacentVertex.getID());
        }
        return null;
    }

    @Override
    public VertexCentricQuery constructQuery(RelationType returnType) {
        BaseVertexCentricQuery vq = super.constructQuery(returnType);
        And condition = vq.getCondition();
        if (!vq.isEmpty()) {
            And newcond = condition instanceof And ? (And)condition : new And(new Condition[]{condition});
            newcond.add(new DirectionCondition(this.vertex, this.getDirection()));
            if (this.adjacentVertex != null) {
                newcond.add(new IncidenceCondition(this.vertex, this.adjacentVertex));
            }
            condition = newcond;
        }
        if (returnType == RelationType.PROPERTY && this.hasTypes() && this.tx.getConfiguration().hasPropertyPrefetching()) {
            boolean isStatic = false;
            for (String type : this.types) {
                if (!this.getType(type).isStatic(Direction.OUT)) continue;
                isStatic = true;
            }
            if (!isStatic) {
                this.vertex.query().includeHidden().properties().iterator().hasNext();
            }
        }
        return new VertexCentricQuery(this.vertex, condition, vq.getDirection(), vq.getQueries(), vq.getLimit());
    }

    private Iterable<TitanRelation> relations(RelationType returnType) {
        return new QueryProcessor<VertexCentricQuery, TitanRelation, SliceQuery>(this.constructQuery(returnType), this.tx.edgeProcessor);
    }

    protected SimpleVertexQueryProcessor getSimpleQuery(RelationType relationType, InternalVertex vertex) {
        if (!vertex.isLoaded() || this.types.length > 1 || this.includeHidden || this.adjacentVertex != null || relationType == RelationType.PROPERTY && this.tx.getConfiguration().hasPropertyPrefetching()) {
            return null;
        }
        InternalType type = null;
        if (this.types.length > 0 && (type = this.getType(this.types[0])) == null) {
            return null;
        }
        switch (relationType) {
            case PROPERTY: {
                assert (this.constraints.isEmpty());
                if (this.limit != Integer.MAX_VALUE) {
                    return null;
                }
                return new SimpleVertexQueryProcessor(vertex, (TitanKey)((Object)type));
            }
            case EDGE: {
                if (type != null) {
                    EdgeSerializer.TypedInterval[] sortKeyConstraints = this.getFittingKeyConstraints(type);
                    if (sortKeyConstraints == null) {
                        return null;
                    }
                    return new SimpleVertexQueryProcessor(vertex, this.dir, (TitanLabel)((Object)type), sortKeyConstraints, this.limit);
                }
                if (!this.constraints.isEmpty()) {
                    return null;
                }
                return new SimpleVertexQueryProcessor(vertex, this.dir, (TitanLabel)((Object)type), null, this.limit);
            }
        }
        throw new IllegalArgumentException("Invalid relation type: " + relationType);
    }

    @Override
    public Iterable<TitanEdge> titanEdges() {
        SimpleVertexQueryProcessor qp = this.getSimpleQuery(RelationType.EDGE, this.vertex);
        if (qp != null) {
            return qp.titanEdges();
        }
        return this.relations(RelationType.EDGE);
    }

    @Override
    public Iterable<TitanProperty> properties() {
        SimpleVertexQueryProcessor qp = this.getSimpleQuery(RelationType.PROPERTY, this.vertex);
        if (qp != null) {
            return qp.properties();
        }
        return this.relations(RelationType.PROPERTY);
    }

    @Override
    public Iterable<TitanRelation> relations() {
        return this.relations(RelationType.RELATION);
    }

    @Override
    public Iterable<Edge> edges() {
        return this.titanEdges();
    }

    @Override
    public long count() {
        return Iterables.size(this.titanEdges());
    }

    @Override
    public long propertyCount() {
        return Iterables.size(this.properties());
    }

    public Iterable<Vertex> vertices() {
        SimpleVertexQueryProcessor qp = this.getSimpleQuery(RelationType.EDGE, this.vertex);
        if (qp != null) {
            return qp.vertices();
        }
        return VertexCentricQueryBuilder.edges2Vertices(this.titanEdges(), this.vertex);
    }

    @Override
    public VertexList vertexIds() {
        SimpleVertexQueryProcessor qp = this.getSimpleQuery(RelationType.EDGE, this.vertex);
        if (qp != null) {
            return qp.vertexIds();
        }
        return this.edges2VertexIds(this.titanEdges(), this.vertex);
    }
}

