/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.graphdb.query.BackendQuery;
import com.thinkaurelius.titan.graphdb.query.BaseQuery;
import java.util.ArrayList;
import java.util.List;

public class JointIndexQuery
extends BaseQuery
implements BackendQuery<JointIndexQuery> {
    private final List<String> indexes;
    private final List<IndexQuery> queries;

    private JointIndexQuery(List<String> indexes, List<IndexQuery> queries) {
        Preconditions.checkNotNull(indexes);
        Preconditions.checkNotNull(queries);
        this.indexes = indexes;
        this.queries = queries;
    }

    public JointIndexQuery() {
        this.queries = new ArrayList<IndexQuery>(4);
        this.indexes = new ArrayList<String>(4);
    }

    public void add(String index, IndexQuery query) {
        this.indexes.add(index);
        this.queries.add(query);
    }

    public int size() {
        return this.indexes.size();
    }

    public IndexQuery getQuery(int pos) {
        return this.queries.get(pos);
    }

    public String getIndex(int pos) {
        return this.indexes.get(pos);
    }

    public boolean isEmpty() {
        return this.queries.isEmpty();
    }

    public int hashCode() {
        return this.queries.hashCode() * 330401 + this.indexes.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        JointIndexQuery oth = (JointIndexQuery)other;
        return oth.queries.equals(this.queries) && oth.indexes.equals(this.indexes);
    }

    public String toString() {
        return this.queries.toString();
    }

    @Override
    public JointIndexQuery updateLimit(int newLimit) {
        JointIndexQuery ji = new JointIndexQuery(Lists.newArrayList(this.indexes), Lists.newArrayList(this.queries));
        ji.setLimit(newLimit);
        return ji;
    }
}

