/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.thinkaurelius.titan.core.Parameter;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanIndexQuery;
import com.thinkaurelius.titan.diskstorage.indexing.RawQuery;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.internal.ElementType;
import com.thinkaurelius.titan.graphdb.query.BaseQuery;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexQueryBuilder
extends BaseQuery
implements TitanIndexQuery {
    private static final Logger log = LoggerFactory.getLogger(IndexQueryBuilder.class);
    private static final String VERTEX_PREFIX = "v.";
    private static final String EDGE_PREFIX = "e.";
    private final StandardTitanTx tx;
    private final IndexSerializer serializer;
    private String indexName;
    private String query;
    private final List<Parameter> parameters;
    private String prefix;
    private final String unkownKeyName;

    public IndexQueryBuilder(StandardTitanTx tx, IndexSerializer serializer) {
        Preconditions.checkNotNull((Object)tx);
        Preconditions.checkNotNull((Object)serializer);
        this.tx = tx;
        this.serializer = serializer;
        this.parameters = Lists.newArrayList();
        this.unkownKeyName = tx.getGraph().getConfiguration().getUnknownIndexKeydName();
    }

    public String getIndex() {
        return this.indexName;
    }

    public Parameter[] getParameters() {
        return this.parameters.toArray(new Parameter[this.parameters.size()]);
    }

    public String getQuery() {
        return this.query;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUnknownKeyName() {
        return this.unkownKeyName;
    }

    public IndexQueryBuilder setIndex(String indexName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)indexName));
        this.indexName = indexName;
        return this;
    }

    public IndexQueryBuilder setQuery(String query) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)query));
        this.query = query;
        return this;
    }

    @Override
    public IndexQueryBuilder limit(int limit) {
        super.setLimit(limit);
        return this;
    }

    @Override
    public IndexQueryBuilder addParameter(Parameter para) {
        this.parameters.add(para);
        return this;
    }

    @Override
    public IndexQueryBuilder addParameters(Iterable<Parameter> paras) {
        Iterables.addAll(this.parameters, paras);
        return this;
    }

    @Override
    public IndexQueryBuilder addParameters(Parameter ... paras) {
        for (Parameter para : paras) {
            this.addParameter(para);
        }
        return this;
    }

    private Iterable<TitanIndexQuery.Result<TitanElement>> execute(ElementType resultType) {
        Preconditions.checkNotNull((Object)this.indexName);
        Preconditions.checkNotNull((Object)this.query);
        if (this.tx.hasModifications()) {
            log.warn("Modifications in this transaction might not be accurately reflected in this index query: {}", (Object)this.query);
        }
        Iterable<RawQuery.Result> result = this.serializer.executeQuery(this, resultType, this.tx.getTxHandle(), this.tx);
        final Function<Object, ? extends TitanElement> conversionFct = this.tx.getConversionFunction(resultType);
        return Iterables.filter((Iterable)Iterables.transform(result, (Function)new Function<RawQuery.Result, TitanIndexQuery.Result<TitanElement>>(){

            @Nullable
            public TitanIndexQuery.Result<TitanElement> apply(@Nullable RawQuery.Result result) {
                return new ResultImpl<TitanElement>((Element)conversionFct.apply(result.getResult()), result.getScore(), null);
            }
        }), (Predicate)new Predicate<TitanIndexQuery.Result<TitanElement>>(){

            public boolean apply(@Nullable TitanIndexQuery.Result<TitanElement> r) {
                return !r.getElement().isRemoved();
            }
        });
    }

    @Override
    public Iterable<TitanIndexQuery.Result<Vertex>> vertices() {
        this.setPrefix(VERTEX_PREFIX);
        return this.execute(ElementType.VERTEX);
    }

    @Override
    public Iterable<TitanIndexQuery.Result<Edge>> edges() {
        this.setPrefix(EDGE_PREFIX);
        return this.execute(ElementType.EDGE);
    }

    private void setPrefix(String prefix) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)prefix));
        if (this.prefix == null) {
            this.prefix = prefix;
        }
    }

    private static class ResultImpl<V extends Element>
    implements TitanIndexQuery.Result<V> {
        private final V element;
        private final double score;

        private ResultImpl(V element, double score) {
            this.element = element;
            this.score = score;
        }

        @Override
        public V getElement() {
            return this.element;
        }

        @Override
        public double getScore() {
            return this.score;
        }

        /* synthetic */ ResultImpl(Element x0, double x1, 1 x2) {
            this(x0, x1);
        }
    }
}

