/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanGraphQuery;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.internal.ElementType;
import com.thinkaurelius.titan.graphdb.internal.OrderList;
import com.thinkaurelius.titan.graphdb.query.BackendQueryHolder;
import com.thinkaurelius.titan.graphdb.query.GraphCentricQuery;
import com.thinkaurelius.titan.graphdb.query.JointIndexQuery;
import com.thinkaurelius.titan.graphdb.query.QueryProcessor;
import com.thinkaurelius.titan.graphdb.query.QueryUtil;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.util.stats.ObjectAccumulator;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Query;
import com.tinkerpop.blueprints.Vertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphCentricQueryBuilder
implements TitanGraphQuery {
    private static final Logger log = LoggerFactory.getLogger(GraphCentricQueryBuilder.class);
    private final StandardTitanTx tx;
    private final IndexSerializer serializer;
    private List<PredicateCondition<String, TitanElement>> constraints;
    private OrderList orders = new OrderList();
    private int limit = Integer.MAX_VALUE;
    private static final int DEFAULT_NO_LIMIT = 100;
    private static final int MAX_BASE_LIMIT = 20000;
    private static final int HARD_MAX_LIMIT = 50000;

    public GraphCentricQueryBuilder(StandardTitanTx tx, IndexSerializer serializer) {
        Preconditions.checkNotNull((Object)tx);
        Preconditions.checkNotNull((Object)serializer);
        this.tx = tx;
        this.serializer = serializer;
        this.constraints = new ArrayList<PredicateCondition<String, TitanElement>>(5);
    }

    private TitanGraphQuery has(String key, TitanPredicate predicate, Object condition) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)predicate);
        Preconditions.checkArgument((boolean)predicate.isValidCondition(condition), (String)"Invalid condition: %s", (Object[])new Object[]{condition});
        this.constraints.add(new PredicateCondition(key, predicate, condition));
        return this;
    }

    @Override
    public TitanGraphQuery has(String key, Predicate predicate, Object condition) {
        Preconditions.checkNotNull((Object)key);
        TitanPredicate titanPredicate = TitanPredicate.Converter.convert(predicate);
        return this.has(key, titanPredicate, condition);
    }

    @Override
    public TitanGraphQuery has(TitanKey key, TitanPredicate predicate, Object condition) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)predicate);
        return this.has(key.getName(), predicate, condition);
    }

    @Override
    public TitanGraphQuery has(String key) {
        return this.has(key, (TitanPredicate)Cmp.NOT_EQUAL, (Object)null);
    }

    @Override
    public TitanGraphQuery hasNot(String key) {
        return this.has(key, (TitanPredicate)Cmp.EQUAL, (Object)null);
    }

    @Override
    @Deprecated
    public <T extends Comparable<T>> TitanGraphQuery has(String s, T t, Query.Compare compare) {
        return this.has(s, (Predicate)compare, t);
    }

    @Override
    public TitanGraphQuery has(String key, Object value) {
        return this.has(key, (TitanPredicate)Cmp.EQUAL, value);
    }

    @Override
    public TitanGraphQuery hasNot(String key, Object value) {
        return this.has(key, (TitanPredicate)Cmp.NOT_EQUAL, value);
    }

    @Override
    public <T extends Comparable<?>> TitanGraphQuery interval(String s, T t1, T t2) {
        this.has(s, (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)t1);
        return this.has(s, (TitanPredicate)Cmp.LESS_THAN, (Object)t2);
    }

    @Override
    public TitanGraphQuery limit(int limit) {
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (String)"Non-negative limit expected: %s", (Object[])new Object[]{limit});
        this.limit = limit;
        return this;
    }

    @Override
    public TitanGraphQuery orderBy(String key, Order order) {
        return this.orderBy(this.tx.getPropertyKey(key), order);
    }

    @Override
    public TitanGraphQuery orderBy(TitanKey key, Order order) {
        Preconditions.checkArgument((boolean)Comparable.class.isAssignableFrom(key.getDataType()), (String)"Can only order on keys with comparable data type. [%s] has datatype [%s]", (Object[])new Object[]{key.getName(), key.getDataType()});
        Preconditions.checkArgument((boolean)key.isUnique(Direction.OUT), (String)"Ordering is undefined on multi-valued key [%s]", (Object[])new Object[]{key.getName()});
        Preconditions.checkArgument((!this.orders.containsKey(key.getName()) ? 1 : 0) != 0);
        this.orders.add(key, order);
        return this;
    }

    @Override
    public Iterable<Vertex> vertices() {
        GraphCentricQuery query = this.constructQuery(ElementType.VERTEX);
        return Iterables.filter(new QueryProcessor<GraphCentricQuery, TitanElement, JointIndexQuery>(query, this.tx.elementProcessor), Vertex.class);
    }

    @Override
    public Iterable<Edge> edges() {
        GraphCentricQuery query = this.constructQuery(ElementType.EDGE);
        return Iterables.filter(new QueryProcessor<GraphCentricQuery, TitanElement, JointIndexQuery>(query, this.tx.elementProcessor), Edge.class);
    }

    private GraphCentricQuery constructQuery(ElementType resultType) {
        BackendQueryHolder<JointIndexQuery> query;
        Preconditions.checkNotNull((Object)((Object)resultType));
        if (this.limit == 0) {
            return GraphCentricQuery.emptyQuery(resultType);
        }
        And<TitanElement> conditions = QueryUtil.constraints2QNF(this.tx, this.constraints);
        if (conditions == null) {
            return GraphCentricQuery.emptyQuery(resultType);
        }
        this.orders.makeImmutable();
        if (this.orders.isEmpty()) {
            this.orders = OrderList.NO_ORDER;
        }
        int andClausesNotCovered = 0;
        HashMap andConditionCoverage = Maps.newHashMap();
        for (Condition<TitanElement> condition : conditions.getChildren()) {
            Set<String> indexes = QueryUtil.andClauseIndexCover(resultType, condition, this.serializer);
            if (!indexes.isEmpty()) {
                andConditionCoverage.put(condition, indexes);
                continue;
            }
            ++andClausesNotCovered;
        }
        if (!andConditionCoverage.isEmpty()) {
            JointIndexQuery jointIndexQuery = new JointIndexQuery();
            boolean isSorted = true;
            while (!andConditionCoverage.isEmpty()) {
                ObjectAccumulator<String> counts = new ObjectAccumulator<String>(5);
                for (Set indexes : andConditionCoverage.values()) {
                    for (String index : indexes) {
                        counts.incBy(index, 1.0);
                    }
                }
                for (String index : counts.getObjects()) {
                    if (!GraphCentricQueryBuilder.indexCoversOrder(index, this.orders, resultType)) continue;
                    counts.incBy(index, 1.0);
                }
                String bestIndex = (String)counts.getMaxObject();
                Preconditions.checkNotNull((Object)bestIndex);
                boolean supportsOrder = GraphCentricQueryBuilder.indexCoversOrder(bestIndex, this.orders, resultType);
                And matchingCond = new And((int)counts.getCount(bestIndex));
                Iterator conditer = andConditionCoverage.entrySet().iterator();
                while (conditer.hasNext()) {
                    Map.Entry entry = conditer.next();
                    if (!((Set)entry.getValue()).contains(bestIndex)) continue;
                    matchingCond.add((Condition)entry.getKey());
                    conditer.remove();
                }
                IndexQuery subquery = this.serializer.getQuery(bestIndex, resultType, matchingCond, supportsOrder ? this.orders : OrderList.NO_ORDER);
                jointIndexQuery.add(bestIndex, subquery);
                isSorted = isSorted && supportsOrder;
            }
            int indexLimit = this.limit == Integer.MAX_VALUE ? 100 : Math.min(20000, this.limit);
            indexLimit = Math.min(50000, QueryUtil.adjustLimitForTxModifications(this.tx, andClausesNotCovered, indexLimit));
            jointIndexQuery.setLimit(indexLimit);
            query = new BackendQueryHolder<JointIndexQuery>(jointIndexQuery, andClausesNotCovered == 0, isSorted, null);
        } else {
            query = new BackendQueryHolder<JointIndexQuery>(new JointIndexQuery(), false, false, null);
        }
        return new GraphCentricQuery(resultType, conditions, this.orders, query, this.limit);
    }

    private static final boolean indexCoversOrder(String index, OrderList orders, ElementType resultType) {
        if (orders.isEmpty()) {
            return true;
        }
        if (index.equals("standard")) {
            return false;
        }
        for (int i = 0; i < orders.size(); ++i) {
            boolean found = false;
            for (String keyindex : orders.getKey(i).getIndexes(resultType.getElementType())) {
                if (!keyindex.equals(index)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

