/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.BaseVertexQuery;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.TitanLabel;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.internal.InternalType;
import com.thinkaurelius.titan.graphdb.internal.RelationType;
import com.thinkaurelius.titan.graphdb.query.BackendQueryHolder;
import com.thinkaurelius.titan.graphdb.query.BaseVertexCentricQuery;
import com.thinkaurelius.titan.graphdb.query.QueryUtil;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.VertexArrayList;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.HiddenFilterCondition;
import com.thinkaurelius.titan.graphdb.query.condition.LabelCondition;
import com.thinkaurelius.titan.graphdb.query.condition.MultiCondition;
import com.thinkaurelius.titan.graphdb.query.condition.Or;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.util.datastructures.Interval;
import com.thinkaurelius.titan.util.datastructures.PointInterval;
import com.thinkaurelius.titan.util.datastructures.ProperInterval;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Query;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractVertexCentricQueryBuilder
implements BaseVertexQuery {
    private static final Logger log = LoggerFactory.getLogger(AbstractVertexCentricQueryBuilder.class);
    private static final String[] NO_TYPES = new String[0];
    private static final List<PredicateCondition<String, TitanRelation>> NO_CONSTRAINTS = ImmutableList.of();
    protected final StandardTitanTx tx;
    protected Direction dir = Direction.BOTH;
    protected String[] types = NO_TYPES;
    protected List<PredicateCondition<String, TitanRelation>> constraints = NO_CONSTRAINTS;
    protected boolean includeHidden = false;
    protected int limit = Integer.MAX_VALUE;
    private static final int HARD_MAX_LIMIT = 300000;

    public AbstractVertexCentricQueryBuilder(StandardTitanTx tx, EdgeSerializer serializer) {
        assert (serializer != null);
        assert (tx != null);
        this.tx = tx;
    }

    Direction getDirection() {
        return this.dir;
    }

    private AbstractVertexCentricQueryBuilder addConstraint(String type, TitanPredicate rel, Object value) {
        assert (type != null);
        assert (rel != null);
        if (this.constraints == NO_CONSTRAINTS) {
            this.constraints = new ArrayList<PredicateCondition<String, TitanRelation>>(5);
        }
        this.constraints.add(new PredicateCondition(type, rel, value));
        return this;
    }

    @Override
    public AbstractVertexCentricQueryBuilder has(TitanKey key, Object value) {
        return this.has(key.getName(), value);
    }

    @Override
    public AbstractVertexCentricQueryBuilder has(TitanLabel label, TitanVertex vertex) {
        return this.has(label.getName(), (Object)vertex);
    }

    @Override
    public AbstractVertexCentricQueryBuilder has(String type, Object value) {
        return this.addConstraint(type, Cmp.EQUAL, value);
    }

    @Override
    public AbstractVertexCentricQueryBuilder hasNot(String key, Object value) {
        return this.has(key, (Predicate)Cmp.NOT_EQUAL, value);
    }

    @Override
    public AbstractVertexCentricQueryBuilder has(String key, Predicate predicate, Object value) {
        return this.addConstraint(key, TitanPredicate.Converter.convert(predicate), value);
    }

    @Override
    public AbstractVertexCentricQueryBuilder has(TitanKey key, Predicate predicate, Object value) {
        return this.has(key.getName(), predicate, value);
    }

    @Override
    public AbstractVertexCentricQueryBuilder has(String key) {
        return this.has(key, (Predicate)Cmp.NOT_EQUAL, (Object)null);
    }

    @Override
    public AbstractVertexCentricQueryBuilder hasNot(String key) {
        return this.has(key, (Predicate)Cmp.EQUAL, (Object)null);
    }

    @Override
    public <T extends Comparable<?>> AbstractVertexCentricQueryBuilder interval(TitanKey key, T start, T end) {
        return this.interval(key.getName(), (Comparable)start, (Comparable)end);
    }

    @Override
    public <T extends Comparable<?>> AbstractVertexCentricQueryBuilder interval(String key, T start, T end) {
        this.addConstraint(key, Cmp.GREATER_THAN_EQUAL, start);
        return this.addConstraint(key, Cmp.LESS_THAN, end);
    }

    @Deprecated
    public <T extends Comparable<T>> AbstractVertexCentricQueryBuilder has(String key, T value, Query.Compare compare) {
        return this.addConstraint(key, TitanPredicate.Converter.convert((Predicate)compare), value);
    }

    @Override
    public AbstractVertexCentricQueryBuilder types(TitanType ... type) {
        for (TitanType t : type) {
            this.type(t);
        }
        return this;
    }

    @Override
    public AbstractVertexCentricQueryBuilder labels(String ... labels) {
        this.types = labels;
        return this;
    }

    @Override
    public AbstractVertexCentricQueryBuilder keys(String ... keys) {
        this.types = keys;
        return this;
    }

    public AbstractVertexCentricQueryBuilder type(TitanType type) {
        this.types = new String[]{type.getName()};
        return this;
    }

    @Override
    public AbstractVertexCentricQueryBuilder direction(Direction d) {
        assert (d != null);
        this.dir = d;
        return this;
    }

    public AbstractVertexCentricQueryBuilder includeHidden() {
        this.includeHidden = true;
        return this;
    }

    @Override
    public AbstractVertexCentricQueryBuilder limit(int limit) {
        assert (limit >= 0);
        this.limit = limit;
        return this;
    }

    protected InternalType getType(String typeName) {
        TitanType t = this.tx.getType(typeName);
        if (t == null && !this.tx.getConfiguration().getAutoEdgeTypeMaker().ignoreUndefinedQueryTypes()) {
            throw new IllegalArgumentException("Undefined type used in query: " + typeName);
        }
        return (InternalType)t;
    }

    protected final boolean hasTypes() {
        return this.types.length > 0;
    }

    protected static Iterable<TitanVertex> edges2Vertices(Iterable<TitanEdge> edges, final TitanVertex other) {
        return Iterables.transform(edges, (Function)new Function<TitanEdge, TitanVertex>(){

            @Nullable
            public TitanVertex apply(@Nullable TitanEdge titanEdge) {
                return titanEdge.getOtherVertex(other);
            }
        });
    }

    protected VertexList edges2VertexIds(Iterable<TitanEdge> edges, TitanVertex other) {
        VertexArrayList vertices = new VertexArrayList();
        for (TitanEdge edge : edges) {
            vertices.add(edge.getOtherVertex(other));
        }
        return vertices;
    }

    protected EdgeSerializer.VertexConstraint getVertexConstraint() {
        return null;
    }

    protected BaseVertexCentricQuery constructQuery(RelationType returnType) {
        ImmutableList queries;
        assert (returnType != null);
        if (this.limit == 0) {
            return BaseVertexCentricQuery.emptyQuery();
        }
        if (returnType == RelationType.PROPERTY) {
            if (this.dir == Direction.IN) {
                return BaseVertexCentricQuery.emptyQuery();
            }
            this.dir = Direction.OUT;
        }
        assert (this.getVertexConstraint() == null || returnType == RelationType.EDGE);
        And<TitanRelation> conditions = QueryUtil.constraints2QNF(this.tx, this.constraints);
        if (conditions == null) {
            return BaseVertexCentricQuery.emptyQuery();
        }
        assert (this.limit > 0);
        int sliceLimit = this.limit;
        EdgeSerializer serializer = this.tx.getEdgeSerializer();
        if (!this.hasTypes()) {
            BackendQueryHolder<SliceQuery> query = new BackendQueryHolder<SliceQuery>(serializer.getQuery(returnType), (this.dir == Direction.BOTH || returnType == RelationType.PROPERTY && this.dir == Direction.OUT) && !conditions.hasChildren() && this.includeHidden, true, null);
            if (sliceLimit != Integer.MAX_VALUE && sliceLimit < 0x2AAAAAAA) {
                if (this.dir != Direction.BOTH && (returnType == RelationType.EDGE || returnType == RelationType.RELATION)) {
                    sliceLimit *= 2;
                }
                if (!(this.includeHidden || returnType != RelationType.PROPERTY && returnType != RelationType.RELATION)) {
                    sliceLimit += 3;
                }
            }
            query.getBackendQuery().setLimit(this.computeLimit(conditions, sliceLimit));
            queries = ImmutableList.of(query);
            if (!this.includeHidden) {
                conditions.add(new HiddenFilterCondition());
            }
            conditions.add(returnType);
        } else {
            HashSet<TitanType> ts = new HashSet<TitanType>(this.types.length);
            queries = new ArrayList(this.types.length + 4);
            for (String typeName : this.types) {
                boolean vertexConstraintApplies;
                InternalType type = this.getType(typeName);
                if (type == null || !this.includeHidden && type.isHidden()) continue;
                ts.add(type);
                if (type.isPropertyKey()) {
                    if (returnType == RelationType.EDGE) {
                        throw new IllegalArgumentException("Querying for edges but including a property key: " + type.getName());
                    }
                    returnType = RelationType.PROPERTY;
                }
                if (type.isEdgeLabel()) {
                    if (returnType == RelationType.PROPERTY) {
                        throw new IllegalArgumentException("Querying for properties but including an edge label: " + type.getName());
                    }
                    returnType = RelationType.EDGE;
                }
                EdgeSerializer.TypedInterval[] sortKeyConstraints = new EdgeSerializer.TypedInterval[type.getSortKey().length];
                Object remainingConditions = conditions;
                boolean bl = vertexConstraintApplies = type.getSortKey().length == 0 || conditions.hasChildren();
                if (type.getSortKey().length > 0 && conditions.hasChildren()) {
                    Interval interval;
                    remainingConditions = conditions.clone();
                    sortKeyConstraints = AbstractVertexCentricQueryBuilder.compileSortKeyConstraints(type, this.tx, (And<TitanRelation>)remainingConditions);
                    if (sortKeyConstraints == null) continue;
                    if (sortKeyConstraints[sortKeyConstraints.length - 1] == null || (interval = sortKeyConstraints[sortKeyConstraints.length - 1].interval) == null || !interval.isPoint()) {
                        vertexConstraintApplies = false;
                    }
                }
                Direction[] dirs = new Direction[]{this.dir};
                EdgeSerializer.VertexConstraint vertexConstraint = this.getVertexConstraint();
                if (this.dir == Direction.BOTH && (AbstractVertexCentricQueryBuilder.hasSortKeyConstraints(sortKeyConstraints) || vertexConstraintApplies && vertexConstraint != null)) {
                    dirs = new Direction[]{Direction.OUT, Direction.IN};
                }
                for (Direction dir : dirs) {
                    EdgeSerializer.VertexConstraint vertexCon = vertexConstraint;
                    if (vertexCon == null || !vertexConstraintApplies || type.isUnique(dir)) {
                        vertexCon = null;
                    }
                    EdgeSerializer.TypedInterval[] sortConstraints = sortKeyConstraints;
                    if (AbstractVertexCentricQueryBuilder.hasSortKeyConstraints(sortKeyConstraints) && type.isUnique(dir)) {
                        sortConstraints = new EdgeSerializer.TypedInterval[type.getSortKey().length];
                    }
                    boolean isFitted = !((MultiCondition)remainingConditions).hasChildren() && vertexConstraint == vertexCon && sortConstraints == sortKeyConstraints;
                    SliceQuery q = serializer.getQuery(type, dir, sortConstraints, vertexCon);
                    q.setLimit(this.computeLimit((And<TitanRelation>)remainingConditions, sliceLimit));
                    queries.add(new BackendQueryHolder<SliceQuery>(q, isFitted, true, null));
                }
            }
            if (queries.isEmpty()) {
                return BaseVertexCentricQuery.emptyQuery();
            }
            conditions.add(AbstractVertexCentricQueryBuilder.getTypeCondition(ts));
        }
        return new BaseVertexCentricQuery(QueryUtil.simplifyQNF(conditions), this.dir, (List<BackendQueryHolder<SliceQuery>>)queries, this.limit);
    }

    public EdgeSerializer.TypedInterval[] getFittingKeyConstraints(InternalType type) {
        if (this.constraints.isEmpty()) {
            return new EdgeSerializer.TypedInterval[type.getSortKey().length];
        }
        if (this.dir == Direction.BOTH || type.isUnique(this.dir) || type.getSortKey().length <= 0) {
            return null;
        }
        And<TitanRelation> conditions = QueryUtil.constraints2QNF(this.tx, this.constraints);
        if (conditions == null) {
            return null;
        }
        EdgeSerializer.TypedInterval[] sortKeyConstraints = AbstractVertexCentricQueryBuilder.compileSortKeyConstraints(type, this.tx, conditions);
        if (!conditions.isEmpty()) {
            return null;
        }
        return sortKeyConstraints;
    }

    private static EdgeSerializer.TypedInterval[] compileSortKeyConstraints(InternalType type, StandardTitanTx tx, And<TitanRelation> conditions) {
        long[] sortKeys = type.getSortKey();
        EdgeSerializer.TypedInterval[] sortKeyConstraints = new EdgeSerializer.TypedInterval[type.getSortKey().length];
        for (int i = 0; i < sortKeys.length; ++i) {
            InternalType pktype = (InternalType)tx.getExistingType(sortKeys[i]);
            Interval<Object> interval = null;
            Iterator iter = conditions.iterator();
            while (iter.hasNext()) {
                PredicateCondition atom = (PredicateCondition)iter.next();
                if (!((TitanType)atom.getKey()).equals(pktype) || atom.getPredicate() != Cmp.EQUAL || interval != null) continue;
                interval = new PointInterval<Object>(atom.getValue());
                iter.remove();
            }
            if (interval == null && pktype.isPropertyKey() && Comparable.class.isAssignableFrom(((TitanKey)((Object)pktype)).getDataType())) {
                ProperInterval<Comparable> pint = new ProperInterval<Comparable>();
                Iterator iter2 = conditions.iterator();
                while (iter2.hasNext()) {
                    Object probe;
                    Condition cond = (Condition)iter2.next();
                    if (cond instanceof PredicateCondition) {
                        PredicateCondition atom = (PredicateCondition)cond;
                        if (!((TitanType)atom.getKey()).equals(pktype)) continue;
                        TitanPredicate predicate = atom.getPredicate();
                        Object value = atom.getValue();
                        if (!(predicate instanceof Cmp)) continue;
                        switch ((Cmp)predicate) {
                            case NOT_EQUAL: {
                                break;
                            }
                            case LESS_THAN: {
                                if (pint.getEnd() == null || pint.getEnd().compareTo(value) >= 0) {
                                    pint.setEnd((Comparable)value);
                                    pint.setEndInclusive(false);
                                }
                                iter2.remove();
                                break;
                            }
                            case LESS_THAN_EQUAL: {
                                if (pint.getEnd() == null || pint.getEnd().compareTo(value) > 0) {
                                    pint.setEnd((Comparable)value);
                                    pint.setEndInclusive(true);
                                }
                                iter2.remove();
                                break;
                            }
                            case GREATER_THAN: {
                                if (pint.getStart() == null || pint.getStart().compareTo(value) <= 0) {
                                    pint.setStart((Comparable)value);
                                    pint.setStartInclusive(false);
                                }
                                iter2.remove();
                                break;
                            }
                            case GREATER_THAN_EQUAL: {
                                if (pint.getStart() == null || pint.getStart().compareTo(value) < 0) {
                                    pint.setStart((Comparable)value);
                                    pint.setStartInclusive(true);
                                }
                                iter2.remove();
                            }
                        }
                        continue;
                    }
                    if (!(cond instanceof Or) || !((probe = ((Or)cond).get(0)) instanceof PredicateCondition) || !((PredicateCondition)probe).getKey().equals(pktype) || ((PredicateCondition)probe).getPredicate() != Cmp.EQUAL) continue;
                    Comparable smallest = null;
                    Comparable largest = null;
                    for (Condition child : cond.getChildren()) {
                        assert (child instanceof PredicateCondition);
                        PredicateCondition pc = (PredicateCondition)child;
                        assert (pc.getKey().equals(pktype));
                        assert (pc.getPredicate() == Cmp.EQUAL);
                        Object v = pc.getValue();
                        if (smallest == null) {
                            smallest = (Comparable)v;
                            largest = (Comparable)v;
                            continue;
                        }
                        if (smallest.compareTo(v) > 0) {
                            smallest = (Comparable)v;
                            continue;
                        }
                        if (largest.compareTo(v) >= 0) continue;
                        largest = (Comparable)v;
                    }
                    assert (smallest != null && largest != null);
                    if (pint.getEnd() == null || pint.getEnd().compareTo(largest) > 0) {
                        pint.setEnd(largest);
                        pint.setEndInclusive(true);
                    }
                    if (pint.getStart() != null && pint.getStart().compareTo(smallest) >= 0) continue;
                    pint.setStart(smallest);
                    pint.setStartInclusive(true);
                }
                if (pint.isEmpty()) {
                    return null;
                }
                if (pint.getStart() != null || pint.getEnd() != null) {
                    interval = pint;
                }
            }
            sortKeyConstraints[i] = new EdgeSerializer.TypedInterval(pktype, interval);
            if (interval == null || !interval.isPoint()) break;
        }
        return sortKeyConstraints;
    }

    public static boolean hasSortKeyConstraints(EdgeSerializer.TypedInterval[] cons) {
        return cons.length > 0 && cons[0] != null;
    }

    private static Condition<TitanRelation> getTypeCondition(Set<TitanType> types) {
        assert (!types.isEmpty());
        if (types.size() == 1) {
            return new LabelCondition<TitanRelation>(types.iterator().next());
        }
        Or<TitanRelation> typeCond = new Or<TitanRelation>(types.size());
        for (TitanType type : types) {
            typeCond.add(new LabelCondition(type));
        }
        return typeCond;
    }

    private int computeLimit(And<TitanRelation> conditions, int baseLimit) {
        if (baseLimit == Integer.MAX_VALUE) {
            return baseLimit;
        }
        assert (baseLimit > 0);
        baseLimit = Math.max(baseLimit, Math.min(300000, QueryUtil.adjustLimitForTxModifications(this.tx, conditions.size(), baseLimit)));
        assert (baseLimit > 0);
        return baseLimit;
    }
}

